/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.FileStatusCache$;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex$;
import org.apache.spark.sql.execution.datasources.PartitionDirectory;
import org.apache.spark.sql.execution.datasources.PartitionPath;
import org.apache.spark.sql.execution.datasources.PartitionSpec;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005f\u0001B\f\u0019\u0001\u0015B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\tk\u0001\u0011)\u0019!C\u0001m!Aq\b\u0001B\u0001B\u0003%q\u0007\u0003\u0005A\u0001\t\u0015\r\u0011\"\u0011B\u0011!)\u0005A!A!\u0002\u0013\u0011\u0005\"\u0002$\u0001\t\u00039\u0005b\u0002'\u0001\u0005\u0004%\t\"\u0014\u0005\u0007-\u0002\u0001\u000b\u0011\u0002(\t\u000f]\u0003!\u0019!C\u00051\"1A\f\u0001Q\u0001\neCq!\u0018\u0001C\u0002\u0013%a\f\u0003\u0004k\u0001\u0001\u0006Ia\u0018\u0005\u0006W\u0002!\t\u0005\u001c\u0005\u0006g\u0002!\t\u0005\u001e\u0005\b\u0003\u001f\u0001A\u0011IA\t\u0011\u001d\t\t\u0004\u0001C!\u0003gAq!a\u000f\u0001\t\u0003\ti\u0004C\u0004\u0002J\u0001!\t%a\u0013\t\u000f\u0005\r\u0004\u0001\"\u0011\u0002f!9\u0011q\u000f\u0001\u0005B\u0005e\u0004bBAA\u0001\u0011\u0005\u00111\u0011\u0005\b\u0003w\u0001A\u0011AAK\u0005A\u0019\u0015\r^1m_\u001e4\u0015\u000e\\3J]\u0012,\u0007P\u0003\u0002\u001a5\u0005YA-\u0019;bg>,(oY3t\u0015\tYB$A\u0005fq\u0016\u001cW\u000f^5p]*\u0011QDH\u0001\u0004gFd'BA\u0010!\u0003\u0015\u0019\b/\u0019:l\u0015\t\t#%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002G\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\n\u0017\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\r\u0005s\u0017PU3g!\tic&D\u0001\u0019\u0013\ty\u0003DA\u0005GS2,\u0017J\u001c3fq\u0006a1\u000f]1sWN+7o]5p]B\u0011!gM\u0007\u00029%\u0011A\u0007\b\u0002\r'B\f'o[*fgNLwN\\\u0001\u0006i\u0006\u0014G.Z\u000b\u0002oA\u0011\u0001(P\u0007\u0002s)\u0011!hO\u0001\bG\u0006$\u0018\r\\8h\u0015\taD$\u0001\u0005dCR\fG._:u\u0013\tq\u0014H\u0001\u0007DCR\fGn\\4UC\ndW-\u0001\u0004uC\ndW\rI\u0001\fg&TX-\u00138CsR,7/F\u0001C!\t93)\u0003\u0002EQ\t!Aj\u001c8h\u00031\u0019\u0018N_3J]\nKH/Z:!\u0003\u0019a\u0014N\\5u}Q!\u0001*\u0013&L!\ti\u0003\u0001C\u00031\r\u0001\u0007\u0011\u0007C\u00036\r\u0001\u0007q\u0007C\u0003A\r\u0001\u0007!)\u0001\u0006iC\u0012|w\u000e]\"p]\u001a,\u0012A\u0014\t\u0003\u001fRk\u0011\u0001\u0015\u0006\u0003#J\u000bAaY8oM*\u00111\u000bI\u0001\u0007Q\u0006$wn\u001c9\n\u0005U\u0003&!D\"p]\u001aLw-\u001e:bi&|g.A\u0006iC\u0012|w\u000e]\"p]\u001a\u0004\u0013a\u00044jY\u0016\u001cF/\u0019;vg\u000e\u000b7\r[3\u0016\u0003e\u0003\"!\f.\n\u0005mC\"a\u0004$jY\u0016\u001cF/\u0019;vg\u000e\u000b7\r[3\u0002!\u0019LG.Z*uCR,8oQ1dQ\u0016\u0004\u0013\u0001\u00042bg\u0016dunY1uS>tW#A0\u0011\u0007\u001d\u0002'-\u0003\u0002bQ\t1q\n\u001d;j_:\u0004\"a\u00195\u000e\u0003\u0011T!!\u001a4\u0002\u00079,GOC\u0001h\u0003\u0011Q\u0017M^1\n\u0005%$'aA+S\u0013\u0006i!-Y:f\u0019>\u001c\u0017\r^5p]\u0002\nq\u0002]1si&$\u0018n\u001c8TG\",W.Y\u000b\u0002[B\u0011a.]\u0007\u0002_*\u0011\u0001\u000fH\u0001\u0006if\u0004Xm]\u0005\u0003e>\u0014!b\u0015;sk\u000e$H+\u001f9f\u0003%\u0011xn\u001c;QCRD7/F\u0001v!\u00111h0a\u0001\u000f\u0005]dhB\u0001=|\u001b\u0005I(B\u0001>%\u0003\u0019a$o\\8u}%\t\u0011&\u0003\u0002~Q\u00059\u0001/Y2lC\u001e,\u0017bA@\u0002\u0002\t\u00191+Z9\u000b\u0005uD\u0003\u0003BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%!+\u0001\u0002gg&!\u0011QBA\u0004\u0005\u0011\u0001\u0016\r\u001e5\u0002\u00131L7\u000f\u001e$jY\u0016\u001cHCBA\n\u00037\ti\u0003\u0005\u0003w}\u0006U\u0001cA\u0017\u0002\u0018%\u0019\u0011\u0011\u0004\r\u0003%A\u000b'\u000f^5uS>tG)\u001b:fGR|'/\u001f\u0005\b\u0003;y\u0001\u0019AA\u0010\u0003A\u0001\u0018M\u001d;ji&|gNR5mi\u0016\u00148\u000f\u0005\u0003w}\u0006\u0005\u0002\u0003BA\u0012\u0003Si!!!\n\u000b\u0007\u0005\u001d2(A\u0006fqB\u0014Xm]:j_:\u001c\u0018\u0002BA\u0016\u0003K\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0011\u001d\tyc\u0004a\u0001\u0003?\t1\u0002Z1uC\u001aKG\u000e^3sg\u00069!/\u001a4sKNDGCAA\u001b!\r9\u0013qG\u0005\u0004\u0003sA#\u0001B+oSR\f\u0001CZ5mi\u0016\u0014\b+\u0019:uSRLwN\\:\u0015\t\u0005}\u0012Q\t\t\u0004[\u0005\u0005\u0013bAA\"1\t\t\u0012J\\'f[>\u0014\u0018PR5mK&sG-\u001a=\t\u000f\u0005\u001d\u0013\u00031\u0001\u0002 \u00059a-\u001b7uKJ\u001c\u0018AC5oaV$h)\u001b7fgV\u0011\u0011Q\n\t\u0006O\u0005=\u00131K\u0005\u0004\u0003#B#!B!se\u0006L\b\u0003BA+\u0003;rA!a\u0016\u0002ZA\u0011\u0001\u0010K\u0005\u0004\u00037B\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002`\u0005\u0005$AB*ue&twMC\u0002\u0002\\!\na!Z9vC2\u001cH\u0003BA4\u0003[\u00022aJA5\u0013\r\tY\u0007\u000b\u0002\b\u0005>|G.Z1o\u0011\u001d\tyg\u0005a\u0001\u0003c\n\u0011a\u001c\t\u0004O\u0005M\u0014bAA;Q\t\u0019\u0011I\\=\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\u001f\u0011\u0007\u001d\ni(C\u0002\u0002\u0000!\u00121!\u00138u\u00039a\u0017n\u001d;QCJ$\u0018\u000e^5p]N$B!!\"\u0002\u0014B1q%a\"\u0002\f\nK1!!#)\u0005\u0019!V\u000f\u001d7feA!aO`AG!\rA\u0014qR\u0005\u0004\u0003#K$!F\"bi\u0006dwn\u001a+bE2,\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003\u000f*\u0002\u0019AA\u0010)!\ty$a&\u0002\u001c\u0006}\u0005bBAM-\u0001\u0007\u00111R\u0001\u0010S:\u0004X\u000f\u001e)beRLG/[8og\"1\u0011Q\u0014\fA\u0002\t\u000b!BY1tKRKW.\u001a(t\u0011\u001d\t9E\u0006a\u0001\u0003?\u0001")
public class CatalogFileIndex
implements FileIndex {
    private final SparkSession sparkSession;
    private final CatalogTable table;
    private final long sizeInBytes;
    private final Configuration hadoopConf;
    private final FileStatusCache fileStatusCache;
    private final Option<URI> baseLocation;

    @Override
    public Option<Object> metadataOpsTimeNs() {
        return FileIndex.metadataOpsTimeNs$(this);
    }

    @Override
    public String toString() {
        return FileIndex.toString$(this);
    }

    public CatalogTable table() {
        return this.table;
    }

    @Override
    public long sizeInBytes() {
        return this.sizeInBytes;
    }

    public Configuration hadoopConf() {
        return this.hadoopConf;
    }

    private FileStatusCache fileStatusCache() {
        return this.fileStatusCache;
    }

    private Option<URI> baseLocation() {
        return this.baseLocation;
    }

    @Override
    public StructType partitionSchema() {
        return this.table().partitionSchema();
    }

    @Override
    public Seq<Path> rootPaths() {
        return Option$.MODULE$.option2Iterable(this.baseLocation().map((Function1 & Serializable)x$1 -> new Path(x$1))).toSeq();
    }

    @Override
    public Seq<PartitionDirectory> listFiles(Seq<Expression> partitionFilters, Seq<Expression> dataFilters) {
        return this.filterPartitions(partitionFilters).listFiles((Seq<Expression>)Nil$.MODULE$, dataFilters);
    }

    @Override
    public void refresh() {
        this.fileStatusCache().invalidateAll();
    }

    public InMemoryFileIndex filterPartitions(Seq<Expression> filters) {
        if (this.table().partitionColumnNames().nonEmpty()) {
            long startTime = System.nanoTime();
            Seq selectedPartitions = ExternalCatalogUtils$.MODULE$.listPartitionsByFilter(this.sparkSession.sessionState().conf(), this.sparkSession.sessionState().catalog(), this.table(), filters);
            Seq partitions = (Seq)selectedPartitions.map((Function1 & Serializable)p -> {
                Path path = new Path(p.location());
                FileSystem fs = path.getFileSystem(this.hadoopConf());
                return new PartitionPath(p.toRow(this.partitionSchema(), $this.sparkSession.sessionState().conf().sessionLocalTimeZone()), path.makeQualified(fs.getUri(), fs.getWorkingDirectory()));
            });
            PartitionSpec partitionSpec = new PartitionSpec(this.partitionSchema(), (Seq<PartitionPath>)partitions);
            long timeNs = System.nanoTime() - startTime;
            return new InMemoryFileIndex(this.sparkSession, (Seq<Path>)((Seq)partitionSpec.partitions().map((Function1 & Serializable)x$2 -> x$2.path())), (Map<String, String>)Predef$.MODULE$.Map().empty(), (Option<StructType>)new Some((Object)partitionSpec.partitionColumns()), this.fileStatusCache(), (Option<PartitionSpec>)new Some((Object)partitionSpec), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)timeNs)));
        }
        return new InMemoryFileIndex(this.sparkSession, this.rootPaths(), (Map<String, String>)this.table().storage().properties(), (Option<StructType>)None$.MODULE$, this.fileStatusCache(), InMemoryFileIndex$.MODULE$.$lessinit$greater$default$6(), InMemoryFileIndex$.MODULE$.$lessinit$greater$default$7());
    }

    @Override
    public String[] inputFiles() {
        return this.filterPartitions((Seq<Expression>)Nil$.MODULE$).inputFiles();
    }

    public boolean equals(Object o) {
        Object object = o;
        if (object instanceof CatalogFileIndex) {
            CatalogFileIndex catalogFileIndex = (CatalogFileIndex)object;
            TableIdentifier tableIdentifier = this.table().identifier();
            TableIdentifier tableIdentifier2 = catalogFileIndex.table().identifier();
            return !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null);
        }
        return false;
    }

    public int hashCode() {
        return this.table().identifier().hashCode();
    }

    public Tuple2<Seq<CatalogTablePartition>, Object> listPartitions(Seq<Expression> filters) {
        if (this.table().partitionColumnNames().nonEmpty()) {
            long startTime = System.nanoTime();
            Seq selectedPartitions = ExternalCatalogUtils$.MODULE$.listPartitionsByFilter(this.sparkSession.sessionState().conf(), this.sparkSession.sessionState().catalog(), this.table(), filters);
            long timeNs = System.nanoTime() - startTime;
            return new Tuple2((Object)selectedPartitions, (Object)BoxesRunTime.boxToLong((long)timeNs));
        }
        return new Tuple2((Object)package$.MODULE$.Seq().empty(), (Object)BoxesRunTime.boxToLong((long)0L));
    }

    public InMemoryFileIndex filterPartitions(Seq<CatalogTablePartition> inputPartitions, long baseTimeNs, Seq<Expression> filters) {
        long startTime = System.nanoTime();
        Seq selectedPartitions = ExternalCatalogUtils$.MODULE$.prunePartitionsByFilter(this.table(), inputPartitions, filters, this.sparkSession.sessionState().conf().sessionLocalTimeZone());
        Seq partitions = (Seq)selectedPartitions.map((Function1 & Serializable)p -> {
            Path path = new Path(p.location());
            FileSystem fs = path.getFileSystem(this.hadoopConf());
            return new PartitionPath(p.toRow(this.partitionSchema(), $this.sparkSession.sessionState().conf().sessionLocalTimeZone()), path.makeQualified(fs.getUri(), fs.getWorkingDirectory()));
        });
        PartitionSpec partitionSpec = new PartitionSpec(this.partitionSchema(), (Seq<PartitionPath>)partitions);
        long timeNs = System.nanoTime() - startTime + baseTimeNs;
        SparkSession x$1 = this.sparkSession;
        Seq x$2 = (Seq)partitions.map((Function1 & Serializable)x$3 -> x$3.path());
        Map x$32 = this.table().storage().properties();
        None$ x$4 = None$.MODULE$;
        FileStatusCache x$5 = this.fileStatusCache();
        Some x$6 = new Some((Object)BoxesRunTime.boxToLong((long)timeNs));
        Some x$7 = new Some((Object)partitionSpec);
        return new InMemoryFileIndex(x$1, (Seq<Path>)x$2, (Map<String, String>)x$32, (Option<StructType>)x$4, x$5, (Option<PartitionSpec>)x$7, (Option<Object>)x$6);
    }

    public CatalogFileIndex(SparkSession sparkSession, CatalogTable table, long sizeInBytes) {
        this.sparkSession = sparkSession;
        this.table = table;
        this.sizeInBytes = sizeInBytes;
        FileIndex.$init$(this);
        this.hadoopConf = sparkSession.sessionState().newHadoopConf();
        this.fileStatusCache = FileStatusCache$.MODULE$.getOrCreate(sparkSession);
        Predef$.MODULE$.assert(table.identifier().database().isDefined(), (Function0 & Serializable)() -> "The table identifier must be qualified in CatalogFileIndex");
        this.baseLocation = table.storage().locationUri();
    }
}

