/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.joins;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftSemi$;
import org.apache.spark.sql.catalyst.plans.logical.Join$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.filter.Predicate;
import org.apache.spark.sql.connector.read.SupportsBroadcastVarPushdownFiltering;
import org.apache.spark.sql.execution.FilterExec;
import org.apache.spark.sql.execution.JoiningKeyData;
import org.apache.spark.sql.execution.LeafExecNode;
import org.apache.spark.sql.execution.ProjectExec;
import org.apache.spark.sql.execution.ProxyBroadcastVarAndStageIdentifier;
import org.apache.spark.sql.execution.ProxyVarsWrapper;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.UnionExec;
import org.apache.spark.sql.execution.WrapsBroadcastVarPushDownSupporter;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanExec;
import org.apache.spark.sql.execution.adaptive.QueryStageExec;
import org.apache.spark.sql.execution.aggregate.BaseAggregateExec;
import org.apache.spark.sql.execution.dynamicpruning.PartitionPruning$;
import org.apache.spark.sql.execution.exchange.Exchange;
import org.apache.spark.sql.execution.exchange.ReusedExchangeExec;
import org.apache.spark.sql.execution.joins.BaseJoinExec;
import org.apache.spark.sql.execution.joins.BroadcastVarPushDownData;
import org.apache.spark.sql.execution.joins.BroadcastVarPushDownData$;
import org.apache.spark.sql.execution.joins.BroadcastedJoinKeysWrapperImpl;
import org.apache.spark.sql.execution.joins.HashedRelation;
import org.apache.spark.sql.execution.window.WindowExec;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ObjectType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class BroadcastHashJoinUtil$ {
    public static final BroadcastHashJoinUtil$ MODULE$ = new BroadcastHashJoinUtil$();

    public Seq<BroadcastVarPushDownData> canPushBroadcastedKeysAsFilter(SQLConf conf, Seq<Expression> streamJoinKeys, Seq<Expression> buildJoinKeys, SparkPlan streamPlan, SparkPlan buildPlan) {
        if (conf.pushBroadcastedJoinKeysASFilterToScan()) {
            Seq<WrapsBroadcastVarPushDownSupporter> allStreamSideBatchScans;
            Seq<WrapsBroadcastVarPushDownSupporter> allBuildSideBatchScans = this.getAllBatchScansForSparkPlan((SparkPlan)buildPlan.canonicalized(), this.getAllBatchScansForSparkPlan$default$2());
            if (!allBuildSideBatchScans.equals(allStreamSideBatchScans = this.getAllBatchScansForSparkPlan((SparkPlan)streamPlan.canonicalized(), this.getAllBatchScansForSparkPlan$default$2())) && this.isBuildPlanPrunable(buildPlan)) {
                return this.getPushDownDataSkipBuildSideCheck(conf, streamJoinKeys, buildJoinKeys, streamPlan, buildPlan, allBuildSideBatchScans);
            }
            return (Seq)package$.MODULE$.Seq().empty();
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public void pushBroadcastVar(Broadcast<HashedRelation> bcRelation, Seq<Expression> buildKeysCanonicalized, Seq<BroadcastVarPushDownData> pushDownData) {
        pushDownData.groupBy((Function1 & Serializable)pdd -> pdd.targetBatchScanExec()).values().foreach((Function1 & Serializable)x$1 -> {
            BroadcastHashJoinUtil$.MODULE$.pushBroadcastVarForBatchScan((Broadcast<HashedRelation>)bcRelation, (Seq<Expression>)buildKeysCanonicalized, (Seq<BroadcastVarPushDownData>)x$1);
            return BoxedUnit.UNIT;
        });
    }

    public void pushBroadcastVarForBatchScan(Broadcast<HashedRelation> bcRelation, Seq<Expression> buildKeysCanonicalized, Seq<BroadcastVarPushDownData> pushDownData) {
        int totalJoinKeys = buildKeysCanonicalized.size();
        DataType[] dataTypesArray = (DataType[])((IterableOnceOps)buildKeysCanonicalized.map((Function1 & Serializable)x$2 -> x$2.dataType())).toArray(ClassTag$.MODULE$.apply(DataType.class));
        pushDownData.foreach((Function1 & Serializable)bcData -> {
            BroadcastHashJoinUtil$.$anonfun$pushBroadcastVarForBatchScan$2(bcRelation, dataTypesArray, totalJoinKeys, bcData);
            return BoxedUnit.UNIT;
        });
        pushDownData.headOption().foreach((Function1 & Serializable)x$3 -> {
            BroadcastHashJoinUtil$.$anonfun$pushBroadcastVarForBatchScan$3(x$3);
            return BoxedUnit.UNIT;
        });
    }

    public String getColNameFromUnderlyingScan(SupportsBroadcastVarPushdownFiltering scan, int index) {
        return CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])scan.allAttributes()[index].fieldNames()))).quoted();
    }

    public Tuple2<Seq<WrapsBroadcastVarPushDownSupporter>, Seq<WrapsBroadcastVarPushDownSupporter>> partitionBatchScansToReadyAndUnready(QueryStageExec stage, Map<Object, Seq<WrapsBroadcastVarPushDownSupporter>> cachedBatchScans) {
        return ((IterableOps)cachedBatchScans.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)stage.id()), (Function0 & Serializable)() -> MODULE$.getAllBatchScansForStage(stage))).partition((Function1 & Serializable)batchScanExec -> BoxesRunTime.boxToBoolean((boolean)BroadcastHashJoinUtil$.MODULE$.isBatchScanReady(batchScanExec)));
    }

    public Seq<WrapsBroadcastVarPushDownSupporter> getAllBatchScansForSparkPlan(SparkPlan plan, boolean goInsideStageExec) {
        return (Seq)plan.collectLeaves().flatMap((Function1 & Serializable)x0$1 -> {
            SparkPlan sparkPlan = x0$1;
            if (sparkPlan instanceof WrapsBroadcastVarPushDownSupporter) {
                SparkPlan sparkPlan2 = sparkPlan;
                return new .colon.colon((Object)sparkPlan2, (List)Nil$.MODULE$);
            }
            if (sparkPlan instanceof QueryStageExec) {
                QueryStageExec queryStageExec = (QueryStageExec)sparkPlan;
                if (goInsideStageExec) {
                    return MODULE$.getAllBatchScansForSparkPlan(queryStageExec.plan(), MODULE$.getAllBatchScansForSparkPlan$default$2());
                }
            }
            if (sparkPlan instanceof ReusedExchangeExec) {
                ReusedExchangeExec reusedExchangeExec = (ReusedExchangeExec)sparkPlan;
                if (goInsideStageExec) {
                    return MODULE$.getAllBatchScansForSparkPlan(reusedExchangeExec.child(), MODULE$.getAllBatchScansForSparkPlan$default$2());
                }
            }
            return package$.MODULE$.Seq().empty();
        });
    }

    public boolean getAllBatchScansForSparkPlan$default$2() {
        return true;
    }

    public boolean isStageReadyForMaterialization(QueryStageExec stage, Map<Object, Seq<WrapsBroadcastVarPushDownSupporter>> cachedBatchScans) {
        return ((IterableOnceOps)cachedBatchScans.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)stage.id()), (Function0 & Serializable)() -> MODULE$.getAllBatchScansForStage(stage))).forall((Function1 & Serializable)batchScanExec -> BoxesRunTime.boxToBoolean((boolean)BroadcastHashJoinUtil$.MODULE$.isBatchScanReady(batchScanExec)));
    }

    public Seq<BroadcastVarPushDownData> getPushdownDataForBatchScansUsingJoinKeys(Seq<Expression> canonicalizedBuildKeys, SparkPlan streamPlan, Tuple2<LogicalPlan, Seq<WrapsBroadcastVarPushDownSupporter>> buildPlanAndProxies) {
        Tuple2<LogicalPlan, Seq<WrapsBroadcastVarPushDownSupporter>> tuple2 = buildPlanAndProxies;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        LogicalPlan buildLp = (LogicalPlan)tuple2._1();
        LogicalPlan buildLp2 = buildLp;
        return (Seq)((IterableOps)((IterableOps)streamPlan.collectLeaves().flatMap((Function1 & Serializable)x0$1 -> {
            SparkPlan sparkPlan = x0$1;
            if (sparkPlan instanceof WrapsBroadcastVarPushDownSupporter) {
                SparkPlan sparkPlan2 = sparkPlan;
                return new .colon.colon((Object)sparkPlan2, (List)Nil$.MODULE$);
            }
            return (Seq)package$.MODULE$.Seq().empty();
        })).filter((Function1 & Serializable)bs -> BoxesRunTime.boxToBoolean((boolean)BroadcastHashJoinUtil$.$anonfun$getPushdownDataForBatchScansUsingJoinKeys$2(bs)))).flatMap((Function1 & Serializable)bs -> {
            Seq<JoiningKeyData> jkdsOfInterest = ((WrapsBroadcastVarPushDownSupporter)((Object)bs)).joinKeysDataIfBuildLegPushable(buildPlanAndProxies);
            return (Seq)jkdsOfInterest.map((Function1 & Serializable)jkd -> new BroadcastVarPushDownData(jkd.streamsideLeafJoinAttribIndex(), (WrapsBroadcastVarPushDownSupporter)((Object)bs), jkd.joiningColDataType(), jkd.joinKeyIndexInJoiningKeys(), BroadcastVarPushDownData$.MODULE$.apply$default$5()));
        });
    }

    public boolean isBatchScanReady(WrapsBroadcastVarPushDownSupporter batchScanExec) {
        Option<SupportsBroadcastVarPushdownFiltering> option = batchScanExec.getBroadcastVarPushDownSupportingInstance();
        if (option instanceof Some) {
            Some some = (Some)option;
            SupportsBroadcastVarPushdownFiltering sr = (SupportsBroadcastVarPushdownFiltering)some.value();
            int totalBCVars = BoxesRunTime.unboxToInt((Object)batchScanExec.proxyForPushedBroadcastVar().fold((Function0)(JFunction0.mcI.sp & Serializable)() -> 0, (Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)BroadcastHashJoinUtil$.$anonfun$isBatchScanReady$2(x$4))));
            return totalBCVars <= sr.getPushedBroadcastFiltersCount();
        }
        return true;
    }

    public BroadcastVarPushDownData convertJoinKeyDataToPushDownData(WrapsBroadcastVarPushDownSupporter bs, JoiningKeyData jkd) {
        return new BroadcastVarPushDownData(jkd.streamsideLeafJoinAttribIndex(), bs, jkd.joiningColDataType(), jkd.joinKeyIndexInJoiningKeys(), BroadcastVarPushDownData$.MODULE$.apply$default$5());
    }

    public String convertNameReferencesToString(NamedReference ref) {
        Seq seq = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ref.fieldNames()));
        return ((IterableOnceOps)seq.map((Function1 & Serializable)part -> MODULE$.quoteIfNeeded((String)part))).mkString(".");
    }

    public LogicalPlan getOriginalLogicalPlanForBuildPlan(LogicalPlan joinPlan) {
        return (LogicalPlan)joinPlan.getTagValue(Join$.MODULE$.PRESERVE_JOIN_WITH_SELF_PUSH_HASH()).map((Function1 & Serializable)x$5 -> (LogicalPlan)x$5._2()).get();
    }

    private Seq<BroadcastVarPushDownData> getPushDownDataSkipBuildSideCheck(SQLConf conf, Seq<Expression> streamJoinKeys, Seq<Expression> buildJoinKeys, SparkPlan streamPlan, SparkPlan buildPlan, Seq<WrapsBroadcastVarPushDownSupporter> extraStreamSideProhibits) {
        boolean allowSameDS = conf.allowSameDataSourceOnBuildAndStreamForBCVarPush();
        Seq streamKeysStart = (Seq)((IterableOps)streamJoinKeys.zipWithIndex()).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)BroadcastHashJoinUtil$.$anonfun$getPushDownDataSkipBuildSideCheck$1(x0$1)));
        return (Seq)((IterableOps)streamKeysStart.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BroadcastHashJoinUtil$.$anonfun$getPushDownDataSkipBuildSideCheck$2(check$ifrefutable$1))).map((Function1 & Serializable)x$7 -> {
            Tuple2 tuple2 = x$7;
            if (tuple2 != null) {
                Expression streamKeyStartExp = (Expression)tuple2._1();
                int joinKeyIndex = tuple2._2$mcI$sp();
                Attribute streamKeyStart = (Attribute)streamKeyStartExp;
                Seq<Tuple2<Attribute, WrapsBroadcastVarPushDownSupporter>> batchScansOfInterest = MODULE$.identifyBatchScanOfInterest(streamKeyStart, streamPlan);
                Seq filteredBatchScansOfInterest = (Seq)batchScansOfInterest.flatMap((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        Attribute currentStreamKey = (Attribute)tuple2._1();
                        WrapsBroadcastVarPushDownSupporter runtimeFilteringBatchScan = (WrapsBroadcastVarPushDownSupporter)tuple2._2();
                        SupportsBroadcastVarPushdownFiltering underlyingRuntimeFilteringScan = (SupportsBroadcastVarPushdownFiltering)runtimeFilteringBatchScan.getBroadcastVarPushDownSupportingInstance().get();
                        Attribute streamKey = currentStreamKey;
                        int streamsideLeafJoinAttribIndex = runtimeFilteringBatchScan.output().indexWhere((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)BroadcastHashJoinUtil$.$anonfun$getPushDownDataSkipBuildSideCheck$5(streamKey, x$6)));
                        if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])underlyingRuntimeFilteringScan.allAttributes())) && (allowSameDS || !extraStreamSideProhibits.exists((Function1 & Serializable)that -> BoxesRunTime.boxToBoolean((boolean)runtimeFilteringBatchScan.isSameUnderlyingScanSource(that))))) {
                            String streamsideJoinColName = MODULE$.getColNameFromUnderlyingScan(underlyingRuntimeFilteringScan, streamsideLeafJoinAttribIndex);
                            Set partitionCols = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])underlyingRuntimeFilteringScan.partitionAttributes()), (Function1 & Serializable)ref -> MODULE$.convertNameReferencesToString((NamedReference)ref), ClassTag$.MODULE$.apply(String.class))).toSet();
                            if (!partitionCols.contains((Object)streamsideJoinColName)) {
                                if (!runtimeFilteringBatchScan.containsNonBroadcastVarRuntimeFilters()) {
                                    return new .colon.colon((Object)new BroadcastVarPushDownData(streamsideLeafJoinAttribIndex, runtimeFilteringBatchScan, ((Expression)buildJoinKeys.apply(joinKeyIndex)).dataType(), joinKeyIndex, BroadcastVarPushDownData$.MODULE$.apply$default$5()), (List)Nil$.MODULE$);
                                }
                                return new .colon.colon((Object)new BroadcastVarPushDownData(streamsideLeafJoinAttribIndex, runtimeFilteringBatchScan, ((Expression)buildJoinKeys.apply(joinKeyIndex)).dataType(), joinKeyIndex, BroadcastVarPushDownData$.MODULE$.apply$default$5()), (List)Nil$.MODULE$);
                            }
                            return (Seq)package$.MODULE$.Seq().empty();
                        }
                        return (Seq)package$.MODULE$.Seq().empty();
                    }
                    throw new MatchError((Object)tuple2);
                });
                return filteredBatchScansOfInterest;
            }
            throw new MatchError((Object)tuple2);
        })).flatten(Predef$.MODULE$.$conforms());
    }

    private boolean supportedDataType(DataType dataType) {
        DataType dataType2 = dataType;
        return ByteType$.MODULE$.equals(dataType2) ? true : (ShortType$.MODULE$.equals(dataType2) ? true : (IntegerType$.MODULE$.equals(dataType2) ? true : (LongType$.MODULE$.equals(dataType2) ? true : (StringType$.MODULE$.equals(dataType2) ? true : DateType$.MODULE$.equals(dataType2)))));
    }

    private boolean isBuildPlanPrunable(SparkPlan buildPlan) {
        boolean useNullabilityForPrun = SQLConf$.MODULE$.get().useNullableAsBuildPlanPrunabilityForBCVarPushdown();
        boolean descendJoinToCheckPrunability = SQLConf$.MODULE$.get().descendJoinToCheckBuildPrunabilityForBCVar();
        ListBuffer plansToCheck = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SparkPlan[]{buildPlan}));
        boolean considerPushedBCVarAsPrunability = buildPlan.conf().considerPushedBroadcastvarOnBatchscanAsPrunablity();
        boolean isBuildPlanPrunable = false;
        while (plansToCheck.nonEmpty() && !isBuildPlanPrunable) {
            SparkPlan sparkPlan;
            boolean bl;
            block11: {
                BaseJoinExec baseJoinExec;
                block12: {
                    FilterExec filterExec;
                    Expression expr;
                    SparkPlan planToCheck = (SparkPlan)plansToCheck.remove(0);
                    bl = false;
                    baseJoinExec = null;
                    sparkPlan = planToCheck;
                    if (sparkPlan instanceof FilterExec && PartitionPruning$.MODULE$.isLikelySelective(expr = (filterExec = (FilterExec)sparkPlan).condition(), useNullabilityForPrun)) {
                        isBuildPlanPrunable = true;
                        continue;
                    }
                    if (sparkPlan instanceof WrapsBroadcastVarPushDownSupporter) {
                        SparkPlan sparkPlan2 = sparkPlan;
                        if (considerPushedBCVarAsPrunability && ((WrapsBroadcastVarPushDownSupporter)((Object)sparkPlan2)).proxyForPushedBroadcastVar().isDefined()) {
                            isBuildPlanPrunable = true;
                            continue;
                        }
                    }
                    if (!(sparkPlan instanceof BaseJoinExec)) break block11;
                    bl = true;
                    baseJoinExec = (BaseJoinExec)((Object)sparkPlan);
                    if (!descendJoinToCheckPrunability) break block11;
                    JoinType joinType = baseJoinExec.joinType();
                    LeftSemi$ leftSemi$ = LeftSemi$.MODULE$;
                    if (!(joinType == null ? leftSemi$ != null : !joinType.equals(leftSemi$))) break block12;
                    JoinType joinType2 = baseJoinExec.joinType();
                    Inner$ inner$ = Inner$.MODULE$;
                    if (joinType2 != null ? !joinType2.equals(inner$) : inner$ != null) break block11;
                }
                plansToCheck.prependAll((IterableOnce)baseJoinExec.children());
                continue;
            }
            if (bl) {
                continue;
            }
            if (sparkPlan instanceof ReusedExchangeExec) {
                ReusedExchangeExec reusedExchangeExec = (ReusedExchangeExec)sparkPlan;
                plansToCheck.prepend((Object)reusedExchangeExec.child());
                continue;
            }
            if (sparkPlan instanceof QueryStageExec) {
                QueryStageExec queryStageExec = (QueryStageExec)sparkPlan;
                plansToCheck.prepend((Object)queryStageExec.plan());
                continue;
            }
            if (sparkPlan instanceof AdaptiveSparkPlanExec) {
                AdaptiveSparkPlanExec adaptiveSparkPlanExec = (AdaptiveSparkPlanExec)sparkPlan;
                plansToCheck.prepend((Object)adaptiveSparkPlanExec.inputPlan());
                continue;
            }
            plansToCheck.prependAll((IterableOnce)sparkPlan.children());
        }
        return isBuildPlanPrunable;
    }

    /*
     * Unable to fully structure code
     */
    private Seq<Tuple2<Attribute, WrapsBroadcastVarPushDownSupporter>> identifyBatchScanOfInterest(Attribute streamKeyStart, SparkPlan streamPlan) {
        currentStreamKey = ObjectRef.create((Object)streamKeyStart);
        currentStreamPlan = streamPlan;
        batchScanOfInterest = (Seq)package$.MODULE$.Seq().empty();
        keepGoing = BooleanRef.create((boolean)true);
        while (keepGoing.elem) {
            block22: {
                block21: {
                    var11_7 = currentStreamPlan;
                    if (var11_7 instanceof WindowExec) {
                        keepGoing.elem = false;
                        continue;
                    }
                    if (var11_7 instanceof WrapsBroadcastVarPushDownSupporter && ((WrapsBroadcastVarPushDownSupporter)(var12_8 = var11_7)).getBroadcastVarPushDownSupportingInstance().isDefined()) {
                        batchScanOfInterest = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((Attribute)currentStreamKey.elem)), (Object)var12_8), (List)Nil$.MODULE$);
                        keepGoing.elem = false;
                        continue;
                    }
                    if (var11_7 instanceof QueryStageExec) {
                        var13_9 = (QueryStageExec)var11_7;
                        if (var13_9.isMaterialized()) {
                            keepGoing.elem = false;
                            continue;
                        }
                        currentStreamPlan = var13_9.plan();
                        continue;
                    }
                    if (var11_7 instanceof ReusedExchangeExec) {
                        keepGoing.elem = false;
                        continue;
                    }
                    if (var11_7 instanceof AdaptiveSparkPlanExec) {
                        keepGoing.elem = false;
                        continue;
                    }
                    if (var11_7 instanceof LeafExecNode) {
                        keepGoing.elem = false;
                        continue;
                    }
                    if (!(var11_7 instanceof ProjectExec)) break block21;
                    var14_10 = (ProjectExec)var11_7;
                    var15_11 = false;
                    var16_12 = null;
                    var17_13 = var14_10.projectList().find((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$identifyBatchScanOfInterest$1$adapted(scala.runtime.ObjectRef org.apache.spark.sql.catalyst.expressions.NamedExpression ), (Lorg/apache/spark/sql/catalyst/expressions/NamedExpression;)Ljava/lang/Object;)((ObjectRef)currentStreamKey));
                    if (!(var17_13 instanceof Some)) ** GOTO lbl-1000
                    var15_11 = true;
                    var16_12 = (Some)var17_13;
                    if (var16_12.value() instanceof Attribute) {
                    } else if (var15_11 && (var18_14 = (NamedExpression)var16_12.value()) instanceof Alias && (childExpr = (var19_15 = (Alias)var18_14).child()) instanceof Attribute) {
                        var21_17 = (Attribute)childExpr;
                        currentStreamKey.elem = var21_17;
                    } else {
                        keepGoing.elem = false;
                    }
                    currentStreamPlan = var14_10.child();
                    continue;
                }
                if (!(var11_7 instanceof BaseAggregateExec)) break block22;
                var22_18 = (BaseAggregateExec)var11_7;
                ne = (NamedExpression)var22_18.resultExpressions().find((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$identifyBatchScanOfInterest$2$adapted(scala.runtime.ObjectRef org.apache.spark.sql.catalyst.expressions.NamedExpression ), (Lorg/apache/spark/sql/catalyst/expressions/NamedExpression;)Ljava/lang/Object;)((ObjectRef)currentStreamKey)).get();
                var25_21 = ne;
                if (var25_21 instanceof Attribute) {
                    var26_22 = (Attribute)var25_21;
                    v0 = var22_18.groupingExpressions().find((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$identifyBatchScanOfInterest$3$adapted(org.apache.spark.sql.catalyst.expressions.Attribute org.apache.spark.sql.catalyst.expressions.NamedExpression ), (Lorg/apache/spark/sql/catalyst/expressions/NamedExpression;)Ljava/lang/Object;)((Attribute)var26_22));
                } else if (var25_21 instanceof Alias && (attr = (var27_23 = (Alias)var25_21).child()) instanceof Attribute) {
                    var29_25 = (Attribute)attr;
                    v0 = var22_18.groupingExpressions().find((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$identifyBatchScanOfInterest$4$adapted(org.apache.spark.sql.catalyst.expressions.Attribute org.apache.spark.sql.catalyst.expressions.NamedExpression ), (Lorg/apache/spark/sql/catalyst/expressions/NamedExpression;)Ljava/lang/Object;)((Attribute)var29_25));
                } else {
                    v0 = None$.MODULE$;
                }
                groupNamedExprOpt = v0;
                var30_26 = false;
                var31_27 = null;
                var32_28 = groupNamedExprOpt;
                if (!(var32_28 instanceof Some)) ** GOTO lbl-1000
                var30_26 = true;
                var31_27 = (Some)var32_28;
                attribute = (NamedExpression)var31_27.value();
                if (attribute instanceof Attribute) {
                    var34_30 = (Attribute)attribute;
                    currentStreamKey.elem = var34_30;
                } else if (var30_26 && (var35_31 = (NamedExpression)var31_27.value()) instanceof Alias && (childExpr = (var36_32 = (Alias)var35_31).child()) instanceof Attribute) {
                    var38_34 = (Attribute)childExpr;
                    currentStreamKey.elem = var38_34;
                } else {
                    keepGoing.elem = false;
                }
                currentStreamPlan = (SparkPlan)var22_18.child();
                continue;
            }
            if (var11_7 instanceof UnionExec) {
                var39_35 = (UnionExec)var11_7;
                indexOfStreamCol = var39_35.output().indexWhere((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$identifyBatchScanOfInterest$5$adapted(scala.runtime.ObjectRef org.apache.spark.sql.catalyst.expressions.Attribute ), (Lorg/apache/spark/sql/catalyst/expressions/Attribute;)Ljava/lang/Object;)((ObjectRef)currentStreamKey));
                batchScanOfInterest = (Seq)((IterableOps)var39_35.children().map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$identifyBatchScanOfInterest$6(int org.apache.spark.sql.execution.SparkPlan ), (Lorg/apache/spark/sql/execution/SparkPlan;)Lscala/collection/immutable/Seq;)((int)indexOfStreamCol))).flatten(Predef$.MODULE$.$conforms());
                keepGoing.elem = false;
                continue;
            }
            currentStreamPlan = (SparkPlan)var11_7.children().find((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$identifyBatchScanOfInterest$7$adapted(scala.runtime.ObjectRef org.apache.spark.sql.execution.SparkPlan ), (Lorg/apache/spark/sql/execution/SparkPlan;)Ljava/lang/Object;)((ObjectRef)currentStreamKey)).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$identifyBatchScanOfInterest$9(scala.runtime.BooleanRef ), ()Lscala/runtime/Null$;)((BooleanRef)keepGoing));
        }
        return batchScanOfInterest;
    }

    private Seq<WrapsBroadcastVarPushDownSupporter> getAllBatchScansForStage(QueryStageExec stage) {
        SparkPlan sparkPlan;
        SparkPlan sparkPlan2 = stage.plan();
        if (sparkPlan2 instanceof ReusedExchangeExec) {
            ReusedExchangeExec reusedExchangeExec = (ReusedExchangeExec)sparkPlan2;
            Exchange sourceExchange = reusedExchangeExec.child();
            sparkPlan = sourceExchange;
        } else {
            sparkPlan = sparkPlan2;
        }
        return (Seq)sparkPlan.collectLeaves().collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof WrapsBroadcastVarPushDownSupporter) {
                    A1 A12 = A1;
                    return (B1)A12;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                return sparkPlan instanceof WrapsBroadcastVarPushDownSupporter;
            }
        });
    }

    private String quoteIfNeeded(String part) {
        if (part.matches("[a-zA-Z0-9_]+") && !part.matches("\\d+")) {
            return part;
        }
        return "`" + part.replace("`", "``") + "`";
    }

    public static final /* synthetic */ void $anonfun$pushBroadcastVarForBatchScan$2(Broadcast bcRelation$2, DataType[] dataTypesArray$1, int totalJoinKeys$1, BroadcastVarPushDownData bcData) {
        String streamJoinLeafColName = MODULE$.getColNameFromUnderlyingScan((SupportsBroadcastVarPushdownFiltering)bcData.targetBatchScanExec().getBroadcastVarPushDownSupportingInstance().get(), bcData.streamsideLeafJoinAttribIndex());
        BroadcastedJoinKeysWrapperImpl actualData = new BroadcastedJoinKeysWrapperImpl((Broadcast<HashedRelation>)bcRelation$2, dataTypesArray$1, bcData.joinKeyIndexInJoiningKeys(), totalJoinKeys$1);
        ObjectType dt = new ObjectType(BroadcastedJoinKeysWrapperImpl.class);
        Literal embedAsLiteral = Literal$.MODULE$.create((Object)actualData, (DataType)dt);
        In filter = new In(streamJoinLeafColName, new Object[]{embedAsLiteral});
        ((SupportsBroadcastVarPushdownFiltering)bcData.targetBatchScanExec().getBroadcastVarPushDownSupportingInstance().get()).filter((Predicate[])((Object[])new Predicate[]{filter.toV2()}));
    }

    public static final /* synthetic */ void $anonfun$pushBroadcastVarForBatchScan$3(BroadcastVarPushDownData x$3) {
        x$3.targetBatchScanExec().resetFilteredPartitionsAndInputRdd();
    }

    public static final /* synthetic */ boolean $anonfun$getPushdownDataForBatchScansUsingJoinKeys$2(SparkPlan bs) {
        return ((WrapsBroadcastVarPushDownSupporter)((Object)bs)).proxyForPushedBroadcastVar().isDefined() && !MODULE$.isBatchScanReady((WrapsBroadcastVarPushDownSupporter)((Object)bs));
    }

    public static final /* synthetic */ int $anonfun$isBatchScanReady$3(int x0$1, ProxyBroadcastVarAndStageIdentifier x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
        if (tuple2 != null) {
            int num = tuple2._1$mcI$sp();
            ProxyBroadcastVarAndStageIdentifier proxy = (ProxyBroadcastVarAndStageIdentifier)tuple2._2();
            return num + proxy.joiningKeysData().size();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ int $anonfun$isBatchScanReady$2(ProxyVarsWrapper x$4) {
        return BoxesRunTime.unboxToInt((Object)x$4.proxies().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)BroadcastHashJoinUtil$.$anonfun$isBatchScanReady$3(BoxesRunTime.unboxToInt((Object)x0$1), x1$1))));
    }

    public static final /* synthetic */ boolean $anonfun$getPushDownDataSkipBuildSideCheck$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Expression streamJk = (Expression)tuple2._1();
            return streamJk instanceof Attribute && MODULE$.supportedDataType(streamJk.dataType());
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getPushDownDataSkipBuildSideCheck$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$getPushDownDataSkipBuildSideCheck$5(Attribute streamKey$1, Attribute x$6) {
        Expression expression = x$6.canonicalized();
        Expression expression2 = streamKey$1.canonicalized();
        return !(expression != null ? !expression.equals(expression2) : expression2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$identifyBatchScanOfInterest$1(ObjectRef currentStreamKey$1, NamedExpression x$8) {
        Expression expression = x$8.toAttribute().canonicalized();
        Expression expression2 = ((Attribute)currentStreamKey$1.elem).canonicalized();
        return !(expression != null ? !expression.equals(expression2) : expression2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$identifyBatchScanOfInterest$2(ObjectRef currentStreamKey$1, NamedExpression x$9) {
        Expression expression = x$9.toAttribute().canonicalized();
        Expression expression2 = ((Attribute)currentStreamKey$1.elem).canonicalized();
        return !(expression != null ? !expression.equals(expression2) : expression2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$identifyBatchScanOfInterest$3(Attribute x2$1, NamedExpression x$10) {
        Expression expression = x$10.toAttribute().canonicalized();
        Expression expression2 = x2$1.canonicalized();
        return !(expression != null ? !expression.equals(expression2) : expression2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$identifyBatchScanOfInterest$4(Attribute x5$1, NamedExpression x$11) {
        Expression expression = x$11.toAttribute().canonicalized();
        Expression expression2 = x5$1.canonicalized();
        return !(expression != null ? !expression.equals(expression2) : expression2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$identifyBatchScanOfInterest$5(ObjectRef currentStreamKey$1, Attribute x$12) {
        Expression expression = x$12.canonicalized();
        Expression expression2 = ((Attribute)currentStreamKey$1.elem).canonicalized();
        return !(expression != null ? !expression.equals(expression2) : expression2 != null);
    }

    public static final /* synthetic */ Seq $anonfun$identifyBatchScanOfInterest$6(int indexOfStreamCol$1, SparkPlan child) {
        return MODULE$.identifyBatchScanOfInterest((Attribute)child.output().apply(indexOfStreamCol$1), child);
    }

    public static final /* synthetic */ boolean $anonfun$identifyBatchScanOfInterest$8(ObjectRef currentStreamKey$1, Attribute x$14) {
        Expression expression = x$14.canonicalized();
        Expression expression2 = ((Attribute)currentStreamKey$1.elem).canonicalized();
        return !(expression != null ? !expression.equals(expression2) : expression2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$identifyBatchScanOfInterest$7(ObjectRef currentStreamKey$1, SparkPlan x$13) {
        return x$13.output().exists((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)BroadcastHashJoinUtil$.$anonfun$identifyBatchScanOfInterest$8(currentStreamKey$1, x$14)));
    }

    public static final /* synthetic */ Null$ $anonfun$identifyBatchScanOfInterest$9(BooleanRef keepGoing$1) {
        keepGoing$1.elem = false;
        return null;
    }

    private BroadcastHashJoinUtil$() {
    }

    public static final /* synthetic */ Object $anonfun$identifyBatchScanOfInterest$1$adapted(ObjectRef currentStreamKey$1, NamedExpression x$8) {
        return BoxesRunTime.boxToBoolean((boolean)BroadcastHashJoinUtil$.$anonfun$identifyBatchScanOfInterest$1(currentStreamKey$1, x$8));
    }

    public static final /* synthetic */ Object $anonfun$identifyBatchScanOfInterest$2$adapted(ObjectRef currentStreamKey$1, NamedExpression x$9) {
        return BoxesRunTime.boxToBoolean((boolean)BroadcastHashJoinUtil$.$anonfun$identifyBatchScanOfInterest$2(currentStreamKey$1, x$9));
    }

    public static final /* synthetic */ Object $anonfun$identifyBatchScanOfInterest$3$adapted(Attribute x2$1, NamedExpression x$10) {
        return BoxesRunTime.boxToBoolean((boolean)BroadcastHashJoinUtil$.$anonfun$identifyBatchScanOfInterest$3(x2$1, x$10));
    }

    public static final /* synthetic */ Object $anonfun$identifyBatchScanOfInterest$4$adapted(Attribute x5$1, NamedExpression x$11) {
        return BoxesRunTime.boxToBoolean((boolean)BroadcastHashJoinUtil$.$anonfun$identifyBatchScanOfInterest$4(x5$1, x$11));
    }

    public static final /* synthetic */ Object $anonfun$identifyBatchScanOfInterest$5$adapted(ObjectRef currentStreamKey$1, Attribute x$12) {
        return BoxesRunTime.boxToBoolean((boolean)BroadcastHashJoinUtil$.$anonfun$identifyBatchScanOfInterest$5(currentStreamKey$1, x$12));
    }

    public static final /* synthetic */ Object $anonfun$identifyBatchScanOfInterest$7$adapted(ObjectRef currentStreamKey$1, SparkPlan x$13) {
        return BoxesRunTime.boxToBoolean((boolean)BroadcastHashJoinUtil$.$anonfun$identifyBatchScanOfInterest$7(currentStreamKey$1, x$13));
    }
}

