/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.sources;

import java.util.Set;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.analysis.RelationWrapper;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.classic.ClassicConversions$;
import org.apache.spark.sql.classic.Dataset$;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.execution.LogicalRDD;
import org.apache.spark.sql.execution.LogicalRDD$;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.execution.streaming.sources.ForeachBatchUserFuncException;
import org.apache.spark.sql.types.StructType;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005]4Aa\u0002\u0005\u0001/!AQ\u0005\u0001B\u0001B\u0003%a\u0005\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011\u0015Q\u0005\u0001\"\u0001L\u0011\u0015\u0001\u0006\u0001\"\u0011R\u0011\u0015A\u0007\u0001\"\u0011j\u0011\u0015\u0011\b\u0001\"\u0003t\u0005A1uN]3bG\"\u0014\u0015\r^2i'&t7N\u0003\u0002\n\u0015\u000591o\\;sG\u0016\u001c(BA\u0006\r\u0003%\u0019HO]3b[&twM\u0003\u0002\u000e\u001d\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u001fA\t1a]9m\u0015\t\t\"#A\u0003ta\u0006\u00148N\u0003\u0002\u0014)\u00051\u0011\r]1dQ\u0016T\u0011!F\u0001\u0004_J<7\u0001A\u000b\u00031I\u001a2\u0001A\r\"!\tQr$D\u0001\u001c\u0015\taR$\u0001\u0003mC:<'\"\u0001\u0010\u0002\t)\fg/Y\u0005\u0003Am\u0011aa\u00142kK\u000e$\bC\u0001\u0012$\u001b\u0005Q\u0011B\u0001\u0013\u000b\u0005\u0011\u0019\u0016N\\6\u0002\u0017\t\fGo\u00195Xe&$XM\u001d\t\u0006O)b3HP\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\tIa)\u001e8di&|gN\r\t\u0004[9\u0002T\"\u0001\b\n\u0005=r!a\u0002#bi\u0006\u001cX\r\u001e\t\u0003cIb\u0001\u0001B\u00034\u0001\t\u0007AGA\u0001U#\t)\u0004\b\u0005\u0002(m%\u0011q\u0007\u000b\u0002\b\u001d>$\b.\u001b8h!\t9\u0013(\u0003\u0002;Q\t\u0019\u0011I\\=\u0011\u0005\u001db\u0014BA\u001f)\u0005\u0011auN\\4\u0011\u0005\u001dz\u0014B\u0001!)\u0005\u0011)f.\u001b;\u0002\u000f\u0015t7m\u001c3feB\u00191\t\u0013\u0019\u000e\u0003\u0011S!!\u0012$\u0002\u0011\u0015t7m\u001c3feNT!a\u0012\b\u0002\u0011\r\fG/\u00197zgRL!!\u0013#\u0003#\u0015C\bO]3tg&|g.\u00128d_\u0012,'/\u0001\u0004=S:LGO\u0010\u000b\u0004\u0019:{\u0005cA'\u0001a5\t\u0001\u0002C\u0003&\u0007\u0001\u0007a\u0005C\u0003B\u0007\u0001\u0007!)\u0001\u0005bI\u0012\u0014\u0015\r^2i)\rq$\u000b\u0016\u0005\u0006'\u0012\u0001\raO\u0001\bE\u0006$8\r[%e\u0011\u0015)F\u00011\u0001W\u0003\u0011!\u0017\r^1\u0011\u0005]+gB\u0001-d\u001d\tI&M\u0004\u0002[C:\u00111\f\u0019\b\u00039~k\u0011!\u0018\u0006\u0003=Z\ta\u0001\u0010:p_Rt\u0014\"A\u000b\n\u0005M!\u0012BA\t\u0013\u0013\ty\u0001#\u0003\u0002e\u001d\u00059\u0001/Y2lC\u001e,\u0017B\u00014h\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0002e\u001d\u0005AAo\\*ue&tw\rF\u0001k!\tYwN\u0004\u0002m[B\u0011A\fK\u0005\u0003]\"\na\u0001\u0015:fI\u00164\u0017B\u00019r\u0005\u0019\u0019FO]5oO*\u0011a\u000eK\u0001\u0010G\u0006dGNQ1uG\"<&/\u001b;feR\u0019a\b\u001e<\t\u000bU4\u0001\u0019\u0001\u0017\u0002\u0005\u0011\u001c\b\"B*\u0007\u0001\u0004Y\u0004")
public class ForeachBatchSink<T>
implements Sink {
    private final Function2<Dataset<T>, Object, BoxedUnit> batchWriter;
    private final ExpressionEncoder<T> encoder;

    @Override
    public String name() {
        return Sink.name$(this);
    }

    @Override
    public StructType schema() {
        return Sink.schema$(this);
    }

    @Override
    public Set<TableCapability> capabilities() {
        return Sink.capabilities$(this);
    }

    @Override
    public void addBatch(long batchId, Dataset<Row> data) {
        LogicalRDD node = LogicalRDD$.MODULE$.fromDataset(data.queryExecution().toRdd(), ClassicConversions$.MODULE$.castToImpl(data), false);
        ExpressionEncoder<T> enc = this.encoder;
        scala.collection.immutable.Set withRelations = Predef$.MODULE$.Set().empty();
        Dataset ds = Dataset$.MODULE$.ofRows(ClassicConversions$.MODULE$.castToImpl(data.sparkSession()), node, (scala.collection.immutable.Set<RelationWrapper>)withRelations).as((Encoder)enc);
        this.callBatchWriter(ds, batchId);
    }

    public String toString() {
        return "ForeachBatchSink";
    }

    private void callBatchWriter(Dataset<T> ds, long batchId) {
        try {
            this.batchWriter.apply(ds, (Object)BoxesRunTime.boxToLong((long)batchId));
        }
        catch (Throwable throwable) {
            Throwable e;
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty() && !((e = (Throwable)option.get()) instanceof SparkThrowable)) {
                throw new ForeachBatchUserFuncException(e);
            }
            throw throwable;
        }
    }

    public ForeachBatchSink(Function2<Dataset<T>, Object, BoxedUnit> batchWriter, ExpressionEncoder<T> encoder) {
        this.batchWriter = batchWriter;
        this.encoder = encoder;
        Sink.$init$(this);
    }
}

