/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    expr1 _FUNC_ expr2 - Returns same result as the EQUAL(=) operator for non-null operands,\n      but returns true if both are null, false if one of the them is null.\n  ", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be used in equality comparison. Map type is not supported.\n          For complex types such array/struct, the data types of fields must be orderable.\n  ", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 2;\n       true\n      > SELECT 1 _FUNC_ '1';\n       true\n      > SELECT true _FUNC_ NULL;\n       false\n      > SELECT NULL _FUNC_ NULL;\n       true\n  ", since="1.1.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005]g\u0001B\u000f\u001f\u0001.B\u0001B\u0011\u0001\u0003\u0016\u0004%\ta\u0011\u0005\t\u000f\u0002\u0011\t\u0012)A\u0005\t\"A\u0001\n\u0001BK\u0002\u0013\u00051\t\u0003\u0005J\u0001\tE\t\u0015!\u0003E\u0011\u0015Q\u0005\u0001\"\u0001L\u0011\u0015y\u0005\u0001\"\u0011Q\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u0015q\u0006\u0001\"\u0011`\u0011\u0015I\u0007\u0001\"\u0011k\u0011\u0015A\b\u0001\"\u0015z\u0011\u0015q\b\u0001\"\u0001\u0000\u0011%\t\t\u0001AA\u0001\n\u0003\t\u0019\u0001C\u0005\u0002\n\u0001\t\n\u0011\"\u0001\u0002\f!I\u0011\u0011\u0005\u0001\u0012\u0002\u0013\u0005\u00111\u0002\u0005\n\u0003G\u0001\u0011\u0011!C!\u0003KA\u0011\"!\u000e\u0001\u0003\u0003%\t!a\u000e\t\u0013\u0005}\u0002!!A\u0005\u0002\u0005\u0005\u0003\"CA$\u0001\u0005\u0005I\u0011IA%\u0011%\t9\u0006AA\u0001\n\u0003\tI\u0006C\u0005\u0002^\u0001\t\t\u0011\"\u0011\u0002`!I\u00111\r\u0001\u0002\u0002\u0013\u0005\u0013QM\u0004\n\u0003\u001fs\u0012\u0011!E\u0001\u0003#3\u0001\"\b\u0010\u0002\u0002#\u0005\u00111\u0013\u0005\u0007\u0015^!\t!a+\t\u0013\u00055v#!A\u0005F\u0005=\u0006\"CAY/\u0005\u0005I\u0011QAZ\u0011%\tIlFA\u0001\n\u0003\u000bY\fC\u0005\u0002N^\t\t\u0011\"\u0003\u0002P\niQ)];bY:+H\u000e\\*bM\u0016T!a\b\u0011\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003C\t\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003G\u0011\n1a]9m\u0015\t)c%A\u0003ta\u0006\u00148N\u0003\u0002(Q\u00051\u0011\r]1dQ\u0016T\u0011!K\u0001\u0004_J<7\u0001A\n\u0005\u00011\u0002d\u0007\u0005\u0002.]5\ta$\u0003\u00020=\t\u0001\")\u001b8bef\u001cu.\u001c9be&\u001cxN\u001c\t\u0003cQj\u0011A\r\u0006\u0002g\u0005)1oY1mC&\u0011QG\r\u0002\b!J|G-^2u!\t9tH\u0004\u00029{9\u0011\u0011\bP\u0007\u0002u)\u00111HK\u0001\u0007yI|w\u000e\u001e \n\u0003MJ!A\u0010\u001a\u0002\u000fA\f7m[1hK&\u0011\u0001)\u0011\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003}I\nA\u0001\\3giV\tA\t\u0005\u0002.\u000b&\u0011aI\b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!\u00027fMR\u0004\u0013!\u0002:jO\"$\u0018A\u0002:jO\"$\b%\u0001\u0004=S:LGO\u0010\u000b\u0004\u00196s\u0005CA\u0017\u0001\u0011\u0015\u0011U\u00011\u0001E\u0011\u0015AU\u00011\u0001E\u0003\u0019\u0019\u00180\u001c2pYV\t\u0011\u000b\u0005\u0002S-:\u00111\u000b\u0016\t\u0003sIJ!!\u0016\u001a\u0002\rA\u0013X\rZ3g\u0013\t9\u0006L\u0001\u0004TiJLgn\u001a\u0006\u0003+J\n\u0001B\\;mY\u0006\u0014G.Z\u000b\u00027B\u0011\u0011\u0007X\u0005\u0003;J\u0012qAQ8pY\u0016\fg.\u0001\u0003fm\u0006dGC\u00011d!\t\t\u0014-\u0003\u0002ce\t\u0019\u0011I\\=\t\u000f\u0011D\u0001\u0013!a\u0001K\u0006)\u0011N\u001c9viB\u0011amZ\u0007\u0002A%\u0011\u0001\u000e\t\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0005e_\u001e+gnQ8eKR\u00191.\u001d<\u0011\u00051|W\"A7\u000b\u00059t\u0012aB2pI\u0016<WM\\\u0005\u0003a6\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006e&\u0001\ra]\u0001\u0004GRD\bC\u00017u\u0013\t)XN\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000b]L\u0001\u0019A6\u0002\u0005\u00154\u0018aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\ra%\u0010 \u0005\u0006w*\u0001\r\u0001R\u0001\b]\u0016<H*\u001a4u\u0011\u0015i(\u00021\u0001E\u0003!qWm\u001e*jO\"$\u0018a\u0004:fm\u0016\u00148/Z(qKJ\fg\u000eZ:\u0015\u00031\nAaY8qsR)A*!\u0002\u0002\b!9!\t\u0004I\u0001\u0002\u0004!\u0005b\u0002%\r!\u0003\u0005\r\u0001R\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiAK\u0002E\u0003\u001fY#!!\u0005\u0011\t\u0005M\u0011QD\u0007\u0003\u0003+QA!a\u0006\u0002\u001a\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00037\u0011\u0014AC1o]>$\u0018\r^5p]&!\u0011qDA\u000b\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u0005\t\u0005\u0003S\t\u0019$\u0004\u0002\u0002,)!\u0011QFA\u0018\u0003\u0011a\u0017M\\4\u000b\u0005\u0005E\u0012\u0001\u00026bm\u0006L1aVA\u0016\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tI\u0004E\u00022\u0003wI1!!\u00103\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r\u0001\u00171\t\u0005\n\u0003\u000b\n\u0012\u0011!a\u0001\u0003s\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA&!\u0015\ti%a\u0015a\u001b\t\tyEC\u0002\u0002RI\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)&a\u0014\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u00047\u0006m\u0003\u0002CA#'\u0005\u0005\t\u0019\u00011\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003O\t\t\u0007C\u0005\u0002FQ\t\t\u00111\u0001\u0002:\u00051Q-];bYN$2aWA4\u0011!\t)%FA\u0001\u0002\u0004\u0001\u0007f\u0006\u0001\u0002l\u0005E\u00141OA<\u0003s\ni(a \u0002\u0004\u0006\u0015\u0015\u0011RAF!\ri\u0013QN\u0005\u0004\u0003_r\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003k\n\u0011q\u000b\u0006!A\u0001\u0002S\r\u001f9sc\u0001zf)\u0016(D?\u0002*\u0007\u0010\u001d:3A5\u0002#+\u001a;ve:\u001c\be]1nK\u0002\u0012Xm];mi\u0002\n7\u000f\t;iK\u0002*\u0015+V!MQuJ\u0003e\u001c9fe\u0006$xN\u001d\u0011g_J\u0004cn\u001c8.]VdG\u000eI8qKJ\fg\u000eZ:-\u0015\u0001\u0002\u0003\u0005\t\u0011!EV$\bE]3ukJt7\u000f\t;sk\u0016\u0004\u0013N\u001a\u0011c_RD\u0007%\u0019:fA9,H\u000e\u001c\u0017!M\u0006d7/\u001a\u0011jM\u0002zg.\u001a\u0011pM\u0002\"\b.\u001a\u0011uQ\u0016l\u0007%[:!]VdGN\f\u0006!A\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003w\n!Q\f\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+A\u0015D\bO]\u0019-A\u0015D\bO\u001d\u001a![\u0001\"\b.\u001a\u0011uo>\u0004S\r\u001f9sKN\u001c\u0018n\u001c8tA5,8\u000f\u001e\u0011cK\u0002\u001a\u0018-\\3!if\u0004X\rI8sA\r\fg\u000e\t2fA\r\f7\u000f^3eAQ|\u0007%\u0019\u0011d_6lwN\u001c\u0011usB,GF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0005tG\rI7vgR\u0004#-\u001a\u0011bAQL\b/\u001a\u0011uQ\u0006$\beY1oA\t,\u0007%^:fI\u0002Jg\u000eI3rk\u0006d\u0017\u000e^=!G>l\u0007/\u0019:jg>tg\u0006I'ba\u0002\"\u0018\u0010]3!SN\u0004cn\u001c;!gV\u0004\bo\u001c:uK\u0012t#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!\r>\u0014\beY8na2,\u0007\u0010\t;za\u0016\u001c\be];dQ\u0002\n'O]1z_M$(/^2uY\u0001\"\b.\u001a\u0011eCR\f\u0007\u0005^=qKN\u0004sN\u001a\u0011gS\u0016dGm\u001d\u0011nkN$\bEY3!_J$WM]1cY\u0016t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!!\u0002\u0003sR\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006E\r\u0011`\rVs5i\u0018\u00113w)\u0001\u0003\u0005\t\u0011!A\u0001\"(/^3\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UAE\u0002sLR+O\u0007~\u0003s%M\u0014<\u0015\u0001\u0002\u0003\u0005\t\u0011!AQ\u0014X/\u001a\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!iJ,X\rI0G+:\u001bu\f\t(V\u00192[$\u0002\t\u0011!A\u0001\u0002\u0003EZ1mg\u0016T\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006ET+M\u0019\u0002zf)\u0016(D?\u0002rU\u000b\u0014'<\u0015\u0001\u0002\u0003\u0005\t\u0011!AQ\u0014X/\u001a\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011qQ\u0001\u0006c9\nd\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003\u001b\u000bq\u0002\u001d:fI&\u001c\u0017\r^3`MVt7m]\u0001\u000e\u000bF,\u0018\r\u001c(vY2\u001c\u0016MZ3\u0011\u00055:2#B\f\u0002\u0016\u0006\u0005\u0006cBAL\u0003;#E\tT\u0007\u0003\u00033S1!a'3\u0003\u001d\u0011XO\u001c;j[\u0016LA!a(\u0002\u001a\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\u0005\r\u0016\u0011V\u0007\u0003\u0003KSA!a*\u00020\u0005\u0011\u0011n\\\u0005\u0004\u0001\u0006\u0015FCAAI\u0003!!xn\u0015;sS:<GCAA\u0014\u0003\u0015\t\u0007\u000f\u001d7z)\u0015a\u0015QWA\\\u0011\u0015\u0011%\u00041\u0001E\u0011\u0015A%\u00041\u0001E\u0003\u001d)h.\u00199qYf$B!!0\u0002JB)\u0011'a0\u0002D&\u0019\u0011\u0011\u0019\u001a\u0003\r=\u0003H/[8o!\u0015\t\u0014Q\u0019#E\u0013\r\t9M\r\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005-7$!AA\u00021\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t\t\u000e\u0005\u0003\u0002*\u0005M\u0017\u0002BAk\u0003W\u0011aa\u00142kK\u000e$\b")
public class EqualNullSafe
extends BinaryComparison
implements Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(EqualNullSafe x$0) {
        return EqualNullSafe$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, EqualNullSafe> tupled() {
        return EqualNullSafe$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, EqualNullSafe>> curried() {
        return EqualNullSafe$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String symbol() {
        return "<=>";
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public Object eval(InternalRow input) {
        Object input1 = this.left().eval(input);
        Object input2 = this.right().eval(input);
        if (input1 == null && input2 == null) {
            return BoxesRunTime.boxToBoolean((boolean)true);
        }
        if (input1 == null || input2 == null) {
            return BoxesRunTime.boxToBoolean((boolean)false);
        }
        return BoxesRunTime.boxToBoolean((boolean)this.ordering().equiv(input1, input2));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode eval1 = this.left().genCode(ctx);
        ExprCode eval2 = this.right().genCode(ctx);
        String equalCode = ctx.genEqual(this.left().dataType(), ExprValue$.MODULE$.exprValueToString(eval1.value()), ExprValue$.MODULE$.exprValueToString(eval2.value()));
        return ev.copy(eval1.code().$plus(eval2.code()).$plus(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = (", " && ", ") ||\n           (!", " && !", " && ", ");"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.value(), eval1.isNull(), eval2.isNull(), eval1.isNull(), eval2.isNull(), equalCode}))), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public EqualNullSafe withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    @Override
    public BinaryComparison reverseOperands() {
        return this;
    }

    public EqualNullSafe copy(Expression left, Expression right) {
        return new EqualNullSafe(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "EqualNullSafe";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof EqualNullSafe;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof EqualNullSafe)) return false;
        boolean bl = true;
        if (!bl) return false;
        EqualNullSafe equalNullSafe = (EqualNullSafe)x$1;
        Expression expression = this.left();
        Expression expression2 = equalNullSafe.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = equalNullSafe.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!equalNullSafe.canEqual(this)) return false;
        return true;
    }

    public EqualNullSafe(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

