/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GreaterThan$;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns true if `expr1` is greater than `expr2`.", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be ordered. For example, map type is not orderable, so it\n          is not supported. For complex types such array/struct, the data types of fields must\n          be orderable.\n  ", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 1;\n       true\n      > SELECT 2 _FUNC_ 1.1;\n       true\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-07-30 04:17:52');\n       false\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-08-01 04:17:52');\n       false\n      > SELECT 1 _FUNC_ NULL;\n       NULL\n  ", since="1.0.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001\u0002\u000f\u001e\u0001*B\u0001\"\u0011\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\r\u0002\u0011\t\u0012)A\u0005\u0007\"Aq\t\u0001BK\u0002\u0013\u0005!\t\u0003\u0005I\u0001\tE\t\u0015!\u0003D\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u0015q\u0005\u0001\"\u0011P\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0011\u0015i\u0006\u0001\"\u0015_\u0011\u00151\u0007\u0001\"\u0015h\u0011\u0015a\u0007\u0001\"\u0001n\u0011\u001dq\u0007!!A\u0005\u0002=DqA\u001d\u0001\u0012\u0002\u0013\u00051\u000fC\u0004\u007f\u0001E\u0005I\u0011A:\t\u0011}\u0004\u0011\u0011!C!\u0003\u0003A\u0011\"!\u0005\u0001\u0003\u0003%\t!a\u0005\t\u0013\u0005m\u0001!!A\u0005\u0002\u0005u\u0001\"CA\u0012\u0001\u0005\u0005I\u0011IA\u0013\u0011%\t\u0019\u0004AA\u0001\n\u0003\t)\u0004C\u0005\u0002:\u0001\t\t\u0011\"\u0011\u0002<!I\u0011q\b\u0001\u0002\u0002\u0013\u0005\u0013\u0011I\u0004\n\u0003Wj\u0012\u0011!E\u0001\u0003[2\u0001\u0002H\u000f\u0002\u0002#\u0005\u0011q\u000e\u0005\u0007\u0013Z!\t!a\"\t\u0013\u0005%e#!A\u0005F\u0005-\u0005\"CAG-\u0005\u0005I\u0011QAH\u0011%\t)JFA\u0001\n\u0003\u000b9\nC\u0005\u0002*Z\t\t\u0011\"\u0003\u0002,\nYqI]3bi\u0016\u0014H\u000b[1o\u0015\tqr$A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0011\"\u0003!\u0019\u0017\r^1msN$(B\u0001\u0012$\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003I\u0015\nQa\u001d9be.T!AJ\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0013aA8sO\u000e\u00011\u0003\u0002\u0001,_U\u0002\"\u0001L\u0017\u000e\u0003uI!AL\u000f\u0003!\tKg.\u0019:z\u0007>l\u0007/\u0019:jg>t\u0007C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$a\u0002)s_\u0012,8\r\u001e\t\u0003myr!a\u000e\u001f\u000f\u0005aZT\"A\u001d\u000b\u0005iJ\u0013A\u0002\u001fs_>$h(C\u00013\u0013\ti\u0014'A\u0004qC\u000e\\\u0017mZ3\n\u0005}\u0002%\u0001D*fe&\fG.\u001b>bE2,'BA\u001f2\u0003\u0011aWM\u001a;\u0016\u0003\r\u0003\"\u0001\f#\n\u0005\u0015k\"AC#yaJ,7o]5p]\u0006)A.\u001a4uA\u0005)!/[4ii\u00061!/[4ii\u0002\na\u0001P5oSRtDcA&M\u001bB\u0011A\u0006\u0001\u0005\u0006\u0003\u0016\u0001\ra\u0011\u0005\u0006\u000f\u0016\u0001\raQ\u0001\u000f]VdG.\u00138u_2,'/\u00198u+\u0005\u0001\u0006C\u0001\u0019R\u0013\t\u0011\u0016GA\u0004C_>dW-\u00198\u0002\rMLXNY8m+\u0005)\u0006C\u0001,[\u001d\t9\u0006\f\u0005\u00029c%\u0011\u0011,M\u0001\u0007!J,G-\u001a4\n\u0005mc&AB*ue&twM\u0003\u0002Zc\u0005aa.\u001e7m'\u00064W-\u0012<bYR\u0019qL\u00193\u0011\u0005A\u0002\u0017BA12\u0005\r\te.\u001f\u0005\u0006G\"\u0001\raX\u0001\u0007S:\u0004X\u000f^\u0019\t\u000b\u0015D\u0001\u0019A0\u0002\r%t\u0007/\u001e;3\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0002DQ*DQ![\u0005A\u0002\r\u000bqA\\3x\u0019\u00164G\u000fC\u0003l\u0013\u0001\u00071)\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003=\u0011XM^3sg\u0016|\u0005/\u001a:b]\u0012\u001cH#A\u0016\u0002\t\r|\u0007/\u001f\u000b\u0004\u0017B\f\bbB!\f!\u0003\u0005\ra\u0011\u0005\b\u000f.\u0001\n\u00111\u0001D\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012\u0001\u001e\u0016\u0003\u0007V\\\u0013A\u001e\t\u0003orl\u0011\u0001\u001f\u0006\u0003sj\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005m\f\u0014AC1o]>$\u0018\r^5p]&\u0011Q\u0010\u001f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\r\u0001\u0003BA\u0003\u0003\u001fi!!a\u0002\u000b\t\u0005%\u00111B\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u000e\u0005!!.\u0019<b\u0013\rY\u0016qA\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003+\u00012\u0001MA\f\u0013\r\tI\"\r\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004?\u0006}\u0001\"CA\u0011!\u0005\u0005\t\u0019AA\u000b\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0005\t\u0006\u0003S\tycX\u0007\u0003\u0003WQ1!!\f2\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003c\tYC\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001)\u00028!A\u0011\u0011\u0005\n\u0002\u0002\u0003\u0007q,\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\u0002\u0003{A\u0011\"!\t\u0014\u0003\u0003\u0005\r!!\u0006\u0002\r\u0015\fX/\u00197t)\r\u0001\u00161\t\u0005\t\u0003C!\u0012\u0011!a\u0001?\":\u0002!a\u0012\u0002N\u0005=\u00131KA+\u00033\nY&a\u0018\u0002b\u0005\u0015\u0014q\r\t\u0004Y\u0005%\u0013bAA&;\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA)\u0003\u0015+\u0007\u0010\u001d:2A}3UKT\"`A\u0015D\bO\u001d\u001a![\u0001\u0012V\r^;s]N\u0004CO];fA%4\u0007\u0005Y3yaJ\f\u0004\rI5tA\u001d\u0014X-\u0019;fe\u0002\"\b.\u00198!A\u0016D\bO\u001d\u001aa]\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003/\n!1\u0013\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+A\u0015D\bO]\u0019-A\u0015D\bO\u001d\u001a![\u0001\"\b.\u001a\u0011uo>\u0004S\r\u001f9sKN\u001c\u0018n\u001c8tA5,8\u000f\u001e\u0011cK\u0002\u001a\u0018-\\3!if\u0004X\rI8sA\r\fg\u000e\t2fA\r\f7\u000f^3eAQ|\u0007%\u0019\u0011d_6lwN\u001c\u0011usB,GF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0005tG\rI7vgR\u0004#-\u001a\u0011bAQL\b/\u001a\u0011uQ\u0006$\beY1oA\t,\u0007e\u001c:eKJ,GM\f\u0011G_J\u0004S\r_1na2,G\u0006I7ba\u0002\"\u0018\u0010]3!SN\u0004cn\u001c;!_J$WM]1cY\u0016d\u0003e]8!SRT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011jg\u0002rw\u000e\u001e\u0011tkB\u0004xN\u001d;fI:\u0002ci\u001c:!G>l\u0007\u000f\\3yAQL\b/Z:!gV\u001c\u0007\u000eI1se\u0006Lxf\u001d;sk\u000e$H\u0006\t;iK\u0002\"\u0017\r^1!if\u0004Xm\u001d\u0011pM\u00022\u0017.\u001a7eg\u0002jWo\u001d;\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002#-\u001a\u0011pe\u0012,'/\u00192mK:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011QL\u0001\u0003 *\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003#\u0007I0G+:\u001bu\fI\u0019<\u0015\u0001\u0002\u0003\u0005\t\u0011!AQ\u0014X/\u001a\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!e\u0001zf)\u0016(D?\u0002\nd&M\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!iJ,XM\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011u_~#\u0017\r^3)OI\u0002\u0004'O\u00171o5\u001a\u0004\u0007\t\u00195uE:$(\u000e\u001a(S\u0001zf)\u0016(D?\u0002\"xn\u00183bi\u0016DsE\r\u00191s5\u0002t'L\u001a1AA\"$(M\u001c;kI:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011gC2\u001cXM\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011u_~#\u0017\r^3)OI\u0002\u0004'O\u00171o5\u001a\u0004\u0007\t\u00195uE:$(\u000e\u001a(S\u0001zf)\u0016(D?\u0002\"xn\u00183bi\u0016DsE\r\u00191s5\u0002\u0004(\f\u00192AA\"$(M\u001c;kI:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011gC2\u001cXM\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u00112A}3UKT\"`A9+F\nT\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u001dVcEJ\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t\u0019'A\u00032]Ar\u0003'A\u0003he>,\b/\t\u0002\u0002j\u0005y\u0001O]3eS\u000e\fG/Z0gk:\u001c7/A\u0006He\u0016\fG/\u001a:UQ\u0006t\u0007C\u0001\u0017\u0017'\u00151\u0012\u0011OA?!\u001d\t\u0019(!\u001fD\u0007.k!!!\u001e\u000b\u0007\u0005]\u0014'A\u0004sk:$\u0018.\\3\n\t\u0005m\u0014Q\u000f\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003BA@\u0003\u000bk!!!!\u000b\t\u0005\r\u00151B\u0001\u0003S>L1aPAA)\t\ti'\u0001\u0005u_N#(/\u001b8h)\t\t\u0019!A\u0003baBd\u0017\u0010F\u0003L\u0003#\u000b\u0019\nC\u0003B3\u0001\u00071\tC\u0003H3\u0001\u00071)A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005e\u0015Q\u0015\t\u0006a\u0005m\u0015qT\u0005\u0004\u0003;\u000b$AB(qi&|g\u000eE\u00031\u0003C\u001b5)C\u0002\u0002$F\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAT5\u0005\u0005\t\u0019A&\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002.B!\u0011QAAX\u0013\u0011\t\t,a\u0002\u0003\r=\u0013'.Z2u\u0001")
public class GreaterThan
extends BinaryComparison
implements Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(GreaterThan x$0) {
        return GreaterThan$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, GreaterThan> tupled() {
        return GreaterThan$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, GreaterThan>> curried() {
        return GreaterThan$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public String symbol() {
        return ">";
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return BoxesRunTime.boxToBoolean((boolean)this.ordering().gt(input1, input2));
    }

    @Override
    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    @Override
    public BinaryComparison reverseOperands() {
        return new LessThan(this.right(), this.left());
    }

    public GreaterThan copy(Expression left, Expression right) {
        return new GreaterThan(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "GreaterThan";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GreaterThan;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof GreaterThan)) return false;
        boolean bl = true;
        if (!bl) return false;
        GreaterThan greaterThan = (GreaterThan)x$1;
        Expression expression = this.left();
        Expression expression2 = greaterThan.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = greaterThan.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!greaterThan.canEqual(this)) return false;
        return true;
    }

    public GreaterThan(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

