/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.LessThan$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns true if `expr1` is less than `expr2`.", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be ordered. For example, map type is not orderable, so it\n          is not supported. For complex types such array/struct, the data types of fields must\n          be orderable.\n  ", examples="\n    Examples:\n      > SELECT 1 _FUNC_ 2;\n       true\n      > SELECT 1.1 _FUNC_ '1';\n       false\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-07-30 04:17:52');\n       false\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-08-01 04:17:52');\n       true\n      > SELECT 1 _FUNC_ NULL;\n       NULL\n  ", since="1.0.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001\u0002\u000f\u001e\u0001*B\u0001\"\u0011\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\r\u0002\u0011\t\u0012)A\u0005\u0007\"Aq\t\u0001BK\u0002\u0013\u0005!\t\u0003\u0005I\u0001\tE\t\u0015!\u0003D\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u0015q\u0005\u0001\"\u0011P\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0011\u0015i\u0006\u0001\"\u0015_\u0011\u00151\u0007\u0001\"\u0015h\u0011\u0015a\u0007\u0001\"\u0001n\u0011\u001dq\u0007!!A\u0005\u0002=DqA\u001d\u0001\u0012\u0002\u0013\u00051\u000fC\u0004\u007f\u0001E\u0005I\u0011A:\t\u0011}\u0004\u0011\u0011!C!\u0003\u0003A\u0011\"!\u0005\u0001\u0003\u0003%\t!a\u0005\t\u0013\u0005m\u0001!!A\u0005\u0002\u0005u\u0001\"CA\u0012\u0001\u0005\u0005I\u0011IA\u0013\u0011%\t\u0019\u0004AA\u0001\n\u0003\t)\u0004C\u0005\u0002:\u0001\t\t\u0011\"\u0011\u0002<!I\u0011q\b\u0001\u0002\u0002\u0013\u0005\u0013\u0011I\u0004\n\u0003Wj\u0012\u0011!E\u0001\u0003[2\u0001\u0002H\u000f\u0002\u0002#\u0005\u0011q\u000e\u0005\u0007\u0013Z!\t!a\"\t\u0013\u0005%e#!A\u0005F\u0005-\u0005\"CAG-\u0005\u0005I\u0011QAH\u0011%\t)JFA\u0001\n\u0003\u000b9\nC\u0005\u0002*Z\t\t\u0011\"\u0003\u0002,\nAA*Z:t)\"\fgN\u0003\u0002\u001f?\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u0001\u0013%\u0001\u0005dCR\fG._:u\u0015\t\u00113%A\u0002tc2T!\u0001J\u0013\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0019:\u0013AB1qC\u000eDWMC\u0001)\u0003\ry'oZ\u0002\u0001'\u0011\u00011fL\u001b\u0011\u00051jS\"A\u000f\n\u00059j\"\u0001\u0005\"j]\u0006\u0014\u0018pQ8na\u0006\u0014\u0018n]8o!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u000e \u000f\u0005]bdB\u0001\u001d<\u001b\u0005I$B\u0001\u001e*\u0003\u0019a$o\\8u}%\t!'\u0003\u0002>c\u00059\u0001/Y2lC\u001e,\u0017BA A\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\ti\u0014'\u0001\u0003mK\u001a$X#A\"\u0011\u00051\"\u0015BA#\u001e\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0006Y\u00164G\u000fI\u0001\u0006e&<\u0007\u000e^\u0001\u0007e&<\u0007\u000e\u001e\u0011\u0002\rqJg.\u001b;?)\rYE*\u0014\t\u0003Y\u0001AQ!Q\u0003A\u0002\rCQaR\u0003A\u0002\r\u000baB\\;mY&sGo\u001c7fe\u0006tG/F\u0001Q!\t\u0001\u0014+\u0003\u0002Sc\t9!i\\8mK\u0006t\u0017AB:z[\n|G.F\u0001V!\t1&L\u0004\u0002X1B\u0011\u0001(M\u0005\u00033F\na\u0001\u0015:fI\u00164\u0017BA.]\u0005\u0019\u0019FO]5oO*\u0011\u0011,M\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0004?\n$\u0007C\u0001\u0019a\u0013\t\t\u0017GA\u0002B]fDQa\u0019\u0005A\u0002}\u000ba!\u001b8qkR\f\u0004\"B3\t\u0001\u0004y\u0016AB5oaV$('A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR\u00191\t\u001b6\t\u000b%L\u0001\u0019A\"\u0002\u000f9,w\u000fT3gi\")1.\u0003a\u0001\u0007\u0006Aa.Z<SS\u001eDG/A\bsKZ,'o]3Pa\u0016\u0014\u0018M\u001c3t)\u0005Y\u0013\u0001B2paf$2a\u00139r\u0011\u001d\t5\u0002%AA\u0002\rCqaR\u0006\u0011\u0002\u0003\u00071)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003QT#aQ;,\u0003Y\u0004\"a\u001e?\u000e\u0003aT!!\u001f>\u0002\u0013Ut7\r[3dW\u0016$'BA>2\u0003)\tgN\\8uCRLwN\\\u0005\u0003{b\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u0002!\u0011\t)!a\u0004\u000e\u0005\u0005\u001d!\u0002BA\u0005\u0003\u0017\tA\u0001\\1oO*\u0011\u0011QB\u0001\u0005U\u00064\u0018-C\u0002\\\u0003\u000f\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0006\u0011\u0007A\n9\"C\u0002\u0002\u001aE\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2aXA\u0010\u0011%\t\t\u0003EA\u0001\u0002\u0004\t)\"A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003O\u0001R!!\u000b\u00020}k!!a\u000b\u000b\u0007\u00055\u0012'\u0001\u0006d_2dWm\u0019;j_:LA!!\r\u0002,\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r\u0001\u0016q\u0007\u0005\t\u0003C\u0011\u0012\u0011!a\u0001?\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t\u0019!!\u0010\t\u0013\u0005\u00052#!AA\u0002\u0005U\u0011AB3rk\u0006d7\u000fF\u0002Q\u0003\u0007B\u0001\"!\t\u0015\u0003\u0003\u0005\ra\u0018\u0015\u0018\u0001\u0005\u001d\u0013QJA(\u0003'\n)&!\u0017\u0002\\\u0005}\u0013\u0011MA3\u0003O\u00022\u0001LA%\u0013\r\tY%\b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\t&\u0001\"fqB\u0014\u0018\u0007I0G+:\u001bu\fI3yaJ\u0014\u0004%\f\u0011SKR,(O\\:!iJ,X\rI5gA\u0001,\u0007\u0010\u001d:2A\u0002J7\u000f\t7fgN\u0004C\u000f[1oA\u0001,\u0007\u0010\u001d:3A:\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\u0005]\u0013Aa%\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001*\u0007\u0010\u001d:2Y\u0001*\u0007\u0010\u001d:3A5\u0002C\u000f[3!i^|\u0007%\u001a=qe\u0016\u001c8/[8og\u0002jWo\u001d;!E\u0016\u00043/Y7fAQL\b/\u001a\u0011pe\u0002\u001a\u0017M\u001c\u0011cK\u0002\u001a\u0017m\u001d;fI\u0002\"x\u000eI1!G>lWn\u001c8!if\u0004X\r\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\ng\u000e\u001a\u0011nkN$\bEY3!C\u0002\"\u0018\u0010]3!i\"\fG\u000fI2b]\u0002\u0012W\rI8sI\u0016\u0014X\r\u001a\u0018!\r>\u0014\b%\u001a=b[BdW\r\f\u0011nCB\u0004C/\u001f9fA%\u001c\bE\\8uA=\u0014H-\u001a:bE2,G\u0006I:pA%$(\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!SN\u0004cn\u001c;!gV\u0004\bo\u001c:uK\u0012t\u0003ER8sA\r|W\u000e\u001d7fq\u0002\"\u0018\u0010]3tAM,8\r\u001b\u0011beJ\f\u0017pL:ueV\u001cG\u000f\f\u0011uQ\u0016\u0004C-\u0019;bAQL\b/Z:!_\u001a\u0004c-[3mIN\u0004S.^:u\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003EY3!_J$WM]1cY\u0016t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!\u0018\u0002\u0005GS\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006%\r\u0011`\rVs5i\u0018\u00113w)\u0001\u0003\u0005\t\u0011!A\u0001\"(/^3\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UAEr\u0013\u0007I0G+:\u001bu\fI\u00142OmR\u0001\u0005\t\u0011!A\u0001\u0002c-\u00197tK*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003Co\\0eCR,\u0007f\n\u001a1aej\u0003gN\u00174a\u0001\u0002DGO\u00198uU\u0012t%\u000b\u0011`\rVs5i\u0018\u0011u_~#\u0017\r^3)OI\u0002\u0004'O\u00171o5\u001a\u0004\u0007\t\u00195uE:$(\u000e\u001a(SmR\u0001\u0005\t\u0011!A\u0001\u0002c-\u00197tK*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003Co\\0eCR,\u0007f\n\u001a1aej\u0003gN\u00174a\u0001\u0002DGO\u00198uU\u0012t%\u000b\u0011`\rVs5i\u0018\u0011u_~#\u0017\r^3)OI\u0002\u0004'O\u00171q5\u0002\u0014\u0007\t\u00195uE:$(\u000e\u001a(SmR\u0001\u0005\t\u0011!A\u0001\u0002CO];f\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\n\u0004e\u0018$V\u001d\u000e{\u0006ET+M\u0019nR\u0001\u0005\t\u0011!A\u0001\u0002c*\u0016'M\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAA2\u0003\u0015\td\u0006\r\u00181\u0003\u00159'o\\;qC\t\tI'A\bqe\u0016$\u0017nY1uK~3WO\\2t\u0003!aUm]:UQ\u0006t\u0007C\u0001\u0017\u0017'\u00151\u0012\u0011OA?!\u001d\t\u0019(!\u001fD\u0007.k!!!\u001e\u000b\u0007\u0005]\u0014'A\u0004sk:$\u0018.\\3\n\t\u0005m\u0014Q\u000f\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003BA@\u0003\u000bk!!!!\u000b\t\u0005\r\u00151B\u0001\u0003S>L1aPAA)\t\ti'\u0001\u0005u_N#(/\u001b8h)\t\t\u0019!A\u0003baBd\u0017\u0010F\u0003L\u0003#\u000b\u0019\nC\u0003B3\u0001\u00071\tC\u0003H3\u0001\u00071)A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005e\u0015Q\u0015\t\u0006a\u0005m\u0015qT\u0005\u0004\u0003;\u000b$AB(qi&|g\u000eE\u00031\u0003C\u001b5)C\u0002\u0002$F\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAT5\u0005\u0005\t\u0019A&\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002.B!\u0011QAAX\u0013\u0011\t\t,a\u0002\u0003\r=\u0013'.Z2u\u0001")
public class LessThan
extends BinaryComparison
implements Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(LessThan x$0) {
        return LessThan$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, LessThan> tupled() {
        return LessThan$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, LessThan>> curried() {
        return LessThan$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public String symbol() {
        return "<";
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return BoxesRunTime.boxToBoolean((boolean)this.ordering().lt(input1, input2));
    }

    @Override
    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    @Override
    public BinaryComparison reverseOperands() {
        return new GreaterThan(this.right(), this.left());
    }

    public LessThan copy(Expression left, Expression right) {
        return new LessThan(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "LessThan";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LessThan;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof LessThan)) return false;
        boolean bl = true;
        if (!bl) return false;
        LessThan lessThan = (LessThan)x$1;
        Expression expression = this.left();
        Expression expression2 = lessThan.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = lessThan.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!lessThan.canEqual(this)) return false;
        return true;
    }

    public LessThan(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

