/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns true if `expr1` is less than or equal to `expr2`.", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be ordered. For example, map type is not orderable, so it\n          is not supported. For complex types such array/struct, the data types of fields must\n          be orderable.\n  ", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 2;\n       true\n      > SELECT 1.0 _FUNC_ '1';\n       true\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-07-30 04:17:52');\n       true\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-08-01 04:17:52');\n       true\n      > SELECT 1 _FUNC_ NULL;\n       NULL\n  ", since="1.0.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001\u0002\u000f\u001e\u0001*B\u0001\"\u0011\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\r\u0002\u0011\t\u0012)A\u0005\u0007\"Aq\t\u0001BK\u0002\u0013\u0005!\t\u0003\u0005I\u0001\tE\t\u0015!\u0003D\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u0015q\u0005\u0001\"\u0011P\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0011\u0015i\u0006\u0001\"\u0015_\u0011\u00151\u0007\u0001\"\u0015h\u0011\u0015a\u0007\u0001\"\u0001n\u0011\u001dq\u0007!!A\u0005\u0002=DqA\u001d\u0001\u0012\u0002\u0013\u00051\u000fC\u0004\u007f\u0001E\u0005I\u0011A:\t\u0011}\u0004\u0011\u0011!C!\u0003\u0003A\u0011\"!\u0005\u0001\u0003\u0003%\t!a\u0005\t\u0013\u0005m\u0001!!A\u0005\u0002\u0005u\u0001\"CA\u0012\u0001\u0005\u0005I\u0011IA\u0013\u0011%\t\u0019\u0004AA\u0001\n\u0003\t)\u0004C\u0005\u0002:\u0001\t\t\u0011\"\u0011\u0002<!I\u0011q\b\u0001\u0002\u0002\u0013\u0005\u0013\u0011I\u0004\n\u0003Wj\u0012\u0011!E\u0001\u0003[2\u0001\u0002H\u000f\u0002\u0002#\u0005\u0011q\u000e\u0005\u0007\u0013Z!\t!a\"\t\u0013\u0005%e#!A\u0005F\u0005-\u0005\"CAG-\u0005\u0005I\u0011QAH\u0011%\t)JFA\u0001\n\u0003\u000b9\nC\u0005\u0002*Z\t\t\u0011\"\u0003\u0002,\nyA*Z:t)\"\fgn\u0014:FcV\fGN\u0003\u0002\u001f?\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u0001\u0013%\u0001\u0005dCR\fG._:u\u0015\t\u00113%A\u0002tc2T!\u0001J\u0013\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0019:\u0013AB1qC\u000eDWMC\u0001)\u0003\ry'oZ\u0002\u0001'\u0011\u00011fL\u001b\u0011\u00051jS\"A\u000f\n\u00059j\"\u0001\u0005\"j]\u0006\u0014\u0018pQ8na\u0006\u0014\u0018n]8o!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u000e \u000f\u0005]bdB\u0001\u001d<\u001b\u0005I$B\u0001\u001e*\u0003\u0019a$o\\8u}%\t!'\u0003\u0002>c\u00059\u0001/Y2lC\u001e,\u0017BA A\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\ti\u0014'\u0001\u0003mK\u001a$X#A\"\u0011\u00051\"\u0015BA#\u001e\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0006Y\u00164G\u000fI\u0001\u0006e&<\u0007\u000e^\u0001\u0007e&<\u0007\u000e\u001e\u0011\u0002\rqJg.\u001b;?)\rYE*\u0014\t\u0003Y\u0001AQ!Q\u0003A\u0002\rCQaR\u0003A\u0002\r\u000baB\\;mY&sGo\u001c7fe\u0006tG/F\u0001Q!\t\u0001\u0014+\u0003\u0002Sc\t9!i\\8mK\u0006t\u0017AB:z[\n|G.F\u0001V!\t1&L\u0004\u0002X1B\u0011\u0001(M\u0005\u00033F\na\u0001\u0015:fI\u00164\u0017BA.]\u0005\u0019\u0019FO]5oO*\u0011\u0011,M\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0004?\n$\u0007C\u0001\u0019a\u0013\t\t\u0017GA\u0002B]fDQa\u0019\u0005A\u0002}\u000ba!\u001b8qkR\f\u0004\"B3\t\u0001\u0004y\u0016AB5oaV$('A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR\u00191\t\u001b6\t\u000b%L\u0001\u0019A\"\u0002\u000f9,w\u000fT3gi\")1.\u0003a\u0001\u0007\u0006Aa.Z<SS\u001eDG/A\bsKZ,'o]3Pa\u0016\u0014\u0018M\u001c3t)\u0005Y\u0013\u0001B2paf$2a\u00139r\u0011\u001d\t5\u0002%AA\u0002\rCqaR\u0006\u0011\u0002\u0003\u00071)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003QT#aQ;,\u0003Y\u0004\"a\u001e?\u000e\u0003aT!!\u001f>\u0002\u0013Ut7\r[3dW\u0016$'BA>2\u0003)\tgN\\8uCRLwN\\\u0005\u0003{b\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u0002!\u0011\t)!a\u0004\u000e\u0005\u0005\u001d!\u0002BA\u0005\u0003\u0017\tA\u0001\\1oO*\u0011\u0011QB\u0001\u0005U\u00064\u0018-C\u0002\\\u0003\u000f\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0006\u0011\u0007A\n9\"C\u0002\u0002\u001aE\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2aXA\u0010\u0011%\t\t\u0003EA\u0001\u0002\u0004\t)\"A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003O\u0001R!!\u000b\u00020}k!!a\u000b\u000b\u0007\u00055\u0012'\u0001\u0006d_2dWm\u0019;j_:LA!!\r\u0002,\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r\u0001\u0016q\u0007\u0005\t\u0003C\u0011\u0012\u0011!a\u0001?\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t\u0019!!\u0010\t\u0013\u0005\u00052#!AA\u0002\u0005U\u0011AB3rk\u0006d7\u000fF\u0002Q\u0003\u0007B\u0001\"!\t\u0015\u0003\u0003\u0005\ra\u0018\u0015\u0018\u0001\u0005\u001d\u0013QJA(\u0003'\n)&!\u0017\u0002\\\u0005}\u0013\u0011MA3\u0003O\u00022\u0001LA%\u0013\r\tY%\b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\t&\u0001(fqB\u0014\u0018\u0007I0G+:\u001bu\fI3yaJ\u0014\u0004%\f\u0011SKR,(O\\:!iJ,X\rI5gA\u0001,\u0007\u0010\u001d:2A\u0002J7\u000f\t7fgN\u0004C\u000f[1oA=\u0014\b%Z9vC2\u0004Co\u001c\u0011aKb\u0004(O\r1/\u0003%\t'oZ;nK:$8/\t\u0002\u0002X\u0005\u0011\u0019J\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!Kb\u0004(/\r\u0017!Kb\u0004(O\r\u0011.AQDW\r\t;x_\u0002*\u0007\u0010\u001d:fgNLwN\\:![V\u001cH\u000f\t2fAM\fW.\u001a\u0011usB,\u0007e\u001c:!G\u0006t\u0007EY3!G\u0006\u001cH/\u001a3!i>\u0004\u0013\rI2p[6|g\u000e\t;za\u0016d#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!C:$\u0007%\\;ti\u0002\u0012W\rI1!if\u0004X\r\t;iCR\u00043-\u00198!E\u0016\u0004sN\u001d3fe\u0016$g\u0006\t$pe\u0002*\u00070Y7qY\u0016d\u0003%\\1qAQL\b/\u001a\u0011jg\u0002rw\u000e\u001e\u0011pe\u0012,'/\u00192mK2\u00023o\u001c\u0011ji*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I5tA9|G\u000fI:vaB|'\u000f^3e]\u00012uN\u001d\u0011d_6\u0004H.\u001a=!if\u0004Xm\u001d\u0011tk\u000eD\u0007%\u0019:sCf|3\u000f\u001e:vGRd\u0003\u0005\u001e5fA\u0011\fG/\u0019\u0011usB,7\u000fI8gA\u0019LW\r\u001c3tA5,8\u000f\u001e\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0012W\rI8sI\u0016\u0014\u0018M\u00197f])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\ti&\u0001BP\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\u0012\u0004e\u0018$V\u001d\u000e{\u0006EM\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!iJ,XM\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u00112]A\u0002sLR+O\u0007~\u0003s%M\u0014<\u0015\u0001\u0002\u0003\u0005\t\u0011!AQ\u0014X/\u001a\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!i>|F-\u0019;fQ\u001d\u0012\u0004\u0007M\u001d.a]j3\u0007\r\u00111ii\ntGO\u001b3O%\u0002sLR+O\u0007~\u0003Co\\0eCR,\u0007f\n\u001a1aej\u0003gN\u00174a\u0001\u0002DGO\u00198uU\u0012t%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!iJ,XM\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011u_~#\u0017\r^3)OI\u0002\u0004'O\u00171o5\u001a\u0004\u0007\t\u00195uE:$(\u000e\u001a(S\u0001zf)\u0016(D?\u0002\"xn\u00183bi\u0016DsE\r\u00191s5\u0002\u0004(\f\u00192AA\"$(M\u001c;kI:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI\u0019!?\u001a+fjQ0!\u001dVcEj\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011O+2c%\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005\r\u0014!B\u0019/a9\u0002\u0014!B4s_V\u0004\u0018EAA5\u0003=\u0001(/\u001a3jG\u0006$Xm\u00184v]\u000e\u001c\u0018a\u0004'fgN$\u0006.\u00198Pe\u0016\u000bX/\u00197\u0011\u0005122#\u0002\f\u0002r\u0005u\u0004cBA:\u0003s\u001a5iS\u0007\u0003\u0003kR1!a\u001e2\u0003\u001d\u0011XO\u001c;j[\u0016LA!a\u001f\u0002v\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\u0005}\u0014QQ\u0007\u0003\u0003\u0003SA!a!\u0002\f\u0005\u0011\u0011n\\\u0005\u0004\u007f\u0005\u0005ECAA7\u0003!!xn\u0015;sS:<GCAA\u0002\u0003\u0015\t\u0007\u000f\u001d7z)\u0015Y\u0015\u0011SAJ\u0011\u0015\t\u0015\u00041\u0001D\u0011\u00159\u0015\u00041\u0001D\u0003\u001d)h.\u00199qYf$B!!'\u0002&B)\u0001'a'\u0002 &\u0019\u0011QT\u0019\u0003\r=\u0003H/[8o!\u0015\u0001\u0014\u0011U\"D\u0013\r\t\u0019+\r\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005\u001d&$!AA\u0002-\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\ti\u000b\u0005\u0003\u0002\u0006\u0005=\u0016\u0002BAY\u0003\u000f\u0011aa\u00142kK\u000e$\b")
public class LessThanOrEqual
extends BinaryComparison
implements Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(LessThanOrEqual x$0) {
        return LessThanOrEqual$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, LessThanOrEqual> tupled() {
        return LessThanOrEqual$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, LessThanOrEqual>> curried() {
        return LessThanOrEqual$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public String symbol() {
        return "<=";
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return BoxesRunTime.boxToBoolean((boolean)this.ordering().lteq(input1, input2));
    }

    @Override
    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    @Override
    public BinaryComparison reverseOperands() {
        return new GreaterThanOrEqual(this.right(), this.left());
    }

    public LessThanOrEqual copy(Expression left, Expression right) {
        return new LessThanOrEqual(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "LessThanOrEqual";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LessThanOrEqual;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof LessThanOrEqual)) return false;
        boolean bl = true;
        if (!bl) return false;
        LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)x$1;
        Expression expression = this.left();
        Expression expression2 = lessThanOrEqual.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = lessThanOrEqual.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!lessThanOrEqual.canEqual(this)) return false;
        return true;
    }

    public LessThanOrEqual(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

