/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.plans.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.MultiInstanceRelation;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ScalarSubquery;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlanIntegrity$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlanIntegrity$$anonfun$checkIfSameExprIdNotReused$1$;
import org.apache.spark.sql.catalyst.plans.logical.PlanHelper$;
import org.apache.spark.sql.catalyst.plans.logical.Union;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.types.DataType;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class LogicalPlanIntegrity$ {
    public static final LogicalPlanIntegrity$ MODULE$ = new LogicalPlanIntegrity$();

    public boolean canGetOutputAttrs(LogicalPlan p) {
        return p.resolved() && !p.expressions().exists((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)e.exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogicalPlanIntegrity$.$anonfun$canGetOutputAttrs$2(x0$1)))));
    }

    public Option<String> hasUniqueExprIdsForOutput(LogicalPlan plan2) {
        HashMap exprIds = HashMap$.MODULE$.empty();
        HashSet ignoredExprIds = HashSet$.MODULE$.empty();
        plan2.foreach((Function1 & Serializable)x0$1 -> {
            LogicalPlanIntegrity$.$anonfun$hasUniqueExprIdsForOutput$1(ignoredExprIds, exprIds, x0$1);
            return BoxedUnit.UNIT;
        });
        return exprIds.collectFirst((PartialFunction)new Serializable(ignoredExprIds, plan2){
            private static final long serialVersionUID = 0L;
            private final HashSet ignoredExprIds$1;
            private final LogicalPlan plan$1;

            public final <A1 extends Tuple2<ExprId, HashSet<DataType>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    ExprId exprId = (ExprId)A1._1();
                    HashSet types = (HashSet)A1._2();
                    if (types.size() > 1 && !this.ignoredExprIds$1.contains((Object)exprId)) {
                        return (B1)("Multiple attributes have the same expression ID " + exprId.id() + " but different data types: " + ((IterableOnceOps)types.map((Function1 & Serializable)x$14 -> x$14.sql())).mkString(", ") + ". The plan tree:\n" + this.plan$1.treeString());
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<ExprId, HashSet<DataType>> x1) {
                Tuple2<ExprId, HashSet<DataType>> tuple2 = x1;
                if (tuple2 != null) {
                    ExprId exprId = (ExprId)tuple2._1();
                    HashSet types = (HashSet)tuple2._2();
                    if (types.size() > 1 && !this.ignoredExprIds$1.contains((Object)exprId)) {
                        return true;
                    }
                }
                return false;
            }
            {
                this.ignoredExprIds$1 = ignoredExprIds$1;
                this.plan$1 = plan$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.types.DataType )}, serializedLambda);
            }
        });
    }

    public Option<String> checkIfSameExprIdNotReused(LogicalPlan plan2) {
        return plan2.collectFirst(new Serializable(plan2){
            private static final long serialVersionUID = 0L;
            public final LogicalPlan plan$2;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1.resolved()) {
                    return (B1)A1.expressions().collectFirst((PartialFunction)new Serializable(this){
                        private static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.checkIfSameExprIdNotReused.1 $outer;

                        public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Alias alias;
                            A1 A1 = x1;
                            if (A1 instanceof Alias && ((IterableOnceOps)((AttributeSet)(alias = (Alias)A1).references().filter((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)anonfun$checkIfSameExprIdNotReused$1$$anonfun$applyOrElse$2.$anonfun$applyOrElse$3(x$15)))).map((Function1 & Serializable)x$16 -> x$16.exprId())).exists((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)anonfun$checkIfSameExprIdNotReused$1$$anonfun$applyOrElse$2.$anonfun$applyOrElse$5(alias, x$17)))) {
                                return (B1)("An alias reuses the same expression ID as previously present in an attribute, which is invalid: " + alias.sql() + ". The plan tree:\n" + this.$outer.plan$2.treeString());
                            }
                            return (B1)function1.apply(x1);
                        }

                        public final boolean isDefinedAt(Expression x1) {
                            Alias alias;
                            Expression expression = x1;
                            return expression instanceof Alias && ((IterableOnceOps)((AttributeSet)(alias = (Alias)expression).references().filter((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)anonfun$checkIfSameExprIdNotReused$1$$anonfun$applyOrElse$2.$anonfun$isDefinedAt$1(x$15)))).map((Function1 & Serializable)x$16 -> x$16.exprId())).exists((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)anonfun$checkIfSameExprIdNotReused$1$$anonfun$applyOrElse$2.$anonfun$isDefinedAt$3(alias, x$17)));
                        }

                        public static final /* synthetic */ boolean $anonfun$applyOrElse$3(Attribute x$15) {
                            return x$15.resolved();
                        }

                        public static final /* synthetic */ boolean $anonfun$applyOrElse$5(Alias x2$2, ExprId x$17) {
                            ExprId exprId = x$17;
                            ExprId exprId2 = x2$2.exprId();
                            return !(exprId != null ? !((Object)exprId).equals(exprId2) : exprId2 != null);
                        }

                        public static final /* synthetic */ boolean $anonfun$isDefinedAt$1(Attribute x$15) {
                            return x$15.resolved();
                        }

                        public static final /* synthetic */ boolean $anonfun$isDefinedAt$3(Alias x2$3, ExprId x$17) {
                            ExprId exprId = x$17;
                            ExprId exprId2 = x2$3.exprId();
                            return !(exprId != null ? !((Object)exprId).equals(exprId2) : exprId2 != null);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3$adapted(org.apache.spark.sql.catalyst.expressions.Attribute ), $anonfun$applyOrElse$4(org.apache.spark.sql.catalyst.expressions.Attribute ), $anonfun$applyOrElse$5$adapted(org.apache.spark.sql.catalyst.expressions.Alias org.apache.spark.sql.catalyst.expressions.ExprId ), $anonfun$isDefinedAt$1$adapted(org.apache.spark.sql.catalyst.expressions.Attribute ), $anonfun$isDefinedAt$2(org.apache.spark.sql.catalyst.expressions.Attribute ), $anonfun$isDefinedAt$3$adapted(org.apache.spark.sql.catalyst.expressions.Alias org.apache.spark.sql.catalyst.expressions.ExprId )}, serializedLambda);
                        }
                    });
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                return logicalPlan.resolved();
            }
            {
                this.plan$2 = plan$2;
            }
        }).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Option<String> validateExprIdUniqueness(LogicalPlan plan2) {
        return this.checkIfSameExprIdNotReused(plan2).orElse((Function0 & Serializable)() -> MODULE$.hasUniqueExprIdsForOutput(plan2));
    }

    public Option<String> validateNoDanglingReferences(LogicalPlan plan2) {
        return plan2.collectFirst(new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Command) {
                    return (B1)None$.MODULE$;
                }
                if (A1 instanceof MultiInstanceRelation) {
                    return (B1)None$.MODULE$;
                }
                if (LogicalPlanIntegrity$.MODULE$.canGetOutputAttrs(A1)) {
                    if (A1.missingInput().nonEmpty()) {
                        return (B1)new Some((Object)("Aliases " + A1.missingInput().mkString(", ") + " are dangling in the references for plan:\n " + A1.treeString()));
                    }
                    return (B1)None$.MODULE$;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                if (logicalPlan instanceof Command) {
                    return true;
                }
                if (logicalPlan instanceof MultiInstanceRelation) {
                    return true;
                }
                return LogicalPlanIntegrity$.MODULE$.canGetOutputAttrs(logicalPlan);
            }
        }).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Option<String> validateAggregateExpressions(LogicalPlan plan2) {
        return plan2.collectFirst(new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Aggregate) {
                    None$ none$;
                    Aggregate aggregate = (Aggregate)A1;
                    try {
                        ExprUtils$.MODULE$.assertValidAggregation(aggregate);
                        none$ = None$.MODULE$;
                    }
                    catch (AnalysisException e) {
                        none$ = new Some((Object)("Aggregate: " + aggregate.toString() + " is not a valid aggregate expression: " + e.getSimpleMessage()));
                    }
                    return (B1)none$;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof Aggregate;
            }
        }).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Option<String> validateSchemaOutput(LogicalPlan previousPlan, LogicalPlan currentPlan) {
        if (!DataTypeUtils$.MODULE$.equalsIgnoreNullability((DataType)previousPlan.schema(), (DataType)currentPlan.schema())) {
            return new Some((Object)("The plan output schema has changed from " + previousPlan.schema().sql() + " to " + currentPlan.schema().sql() + ". The previous plan: " + previousPlan.treeString() + "\nThe new plan:\n" + currentPlan.treeString()));
        }
        return None$.MODULE$;
    }

    public Option<String> validateOptimizedPlan(LogicalPlan previousPlan, LogicalPlan currentPlan, boolean lightweight) {
        if (lightweight) {
            None$ validation = previousPlan.resolved() && !currentPlan.resolved() ? new Some((Object)"The plan was previously resolved and now became unresolved.") : None$.MODULE$;
            return validation;
        }
        Some validation = !currentPlan.resolved() ? new Some((Object)("The plan becomes unresolved: " + currentPlan.treeString() + "\nThe previous plan: " + previousPlan.treeString())) : (currentPlan.exists((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)LogicalPlanIntegrity$.$anonfun$validateOptimizedPlan$1(x$18))) ? new Some((Object)("Special expressions are placed in the wrong plan: " + currentPlan.treeString())) : None$.MODULE$);
        validation = validation.orElse((Function0 & Serializable)() -> MODULE$.validateExprIdUniqueness(currentPlan)).orElse((Function0 & Serializable)() -> MODULE$.validateSchemaOutput(previousPlan, currentPlan)).orElse((Function0 & Serializable)() -> MODULE$.validateNoDanglingReferences(currentPlan)).orElse((Function0 & Serializable)() -> MODULE$.validateAggregateExpressions(currentPlan)).map((Function1 & Serializable)err -> err + "\nPrevious schema:" + previousPlan.output().mkString(", ") + "\nPrevious plan: " + previousPlan.treeString());
        return validation;
    }

    public static final /* synthetic */ boolean $anonfun$canGetOutputAttrs$2(Expression x0$1) {
        Expression expression = x0$1;
        if (expression instanceof ScalarSubquery) {
            ScalarSubquery scalarSubquery = (ScalarSubquery)expression;
            return ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])scalarSubquery.plan().schema().fields()));
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$hasUniqueExprIdsForOutput$1(HashSet ignoredExprIds$1, HashMap exprIds$1, LogicalPlan x0$1) {
        Union union;
        LogicalPlan logicalPlan = x0$1;
        if (logicalPlan instanceof Union && (union = (Union)logicalPlan).resolved()) {
            union.output().foreach((Function1 & Serializable)x$13 -> (HashSet)ignoredExprIds$1.$plus$eq((Object)x$13.exprId()));
            return;
        }
        if (MODULE$.canGetOutputAttrs(logicalPlan)) {
            logicalPlan.output().foreach((Function1 & Serializable)a -> {
                if (a.resolved()) {
                    HashSet prevTypes = (HashSet)exprIds$1.getOrElseUpdate((Object)a.exprId(), (Function0 & Serializable)() -> HashSet$.MODULE$.empty());
                    return prevTypes.$plus$eq((Object)a.dataType().asNullable());
                }
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$validateOptimizedPlan$1(LogicalPlan x$18) {
        return PlanHelper$.MODULE$.specialExpressionsInUnsupportedOperator(x$18).nonEmpty();
    }

    private LogicalPlanIntegrity$() {
    }
}

