/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.connector.catalog.ColumnDefaultValue;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.types.DataType;

@Evolving
public interface TableChange {
    public static TableChange setProperty(String property, String value) {
        return new SetProperty(property, value);
    }

    public static TableChange removeProperty(String property) {
        return new RemoveProperty(property);
    }

    public static TableChange addColumn(String[] fieldNames, DataType dataType) {
        return new AddColumn(fieldNames, dataType, true, null, null, null);
    }

    public static TableChange addColumn(String[] fieldNames, DataType dataType, boolean isNullable) {
        return new AddColumn(fieldNames, dataType, isNullable, null, null, null);
    }

    public static TableChange addColumn(String[] fieldNames, DataType dataType, boolean isNullable, String comment) {
        return new AddColumn(fieldNames, dataType, isNullable, comment, null, null);
    }

    public static TableChange addColumn(String[] fieldNames, DataType dataType, boolean isNullable, String comment, ColumnPosition position, ColumnDefaultValue defaultValue) {
        return new AddColumn(fieldNames, dataType, isNullable, comment, position, defaultValue);
    }

    public static TableChange renameColumn(String[] fieldNames, String newName) {
        return new RenameColumn(fieldNames, newName);
    }

    public static TableChange updateColumnType(String[] fieldNames, DataType newDataType) {
        return new UpdateColumnType(fieldNames, newDataType);
    }

    public static TableChange updateColumnNullability(String[] fieldNames, boolean nullable) {
        return new UpdateColumnNullability(fieldNames, nullable);
    }

    public static TableChange updateColumnComment(String[] fieldNames, String newComment) {
        return new UpdateColumnComment(fieldNames, newComment);
    }

    public static TableChange updateColumnPosition(String[] fieldNames, ColumnPosition newPosition) {
        return new UpdateColumnPosition(fieldNames, newPosition);
    }

    public static TableChange updateColumnDefaultValue(String[] fieldNames, String newDefaultValue) {
        return new UpdateColumnDefaultValue(fieldNames, newDefaultValue);
    }

    public static TableChange deleteColumn(String[] fieldNames, Boolean ifExists) {
        return new DeleteColumn(fieldNames, ifExists);
    }

    public static TableChange clusterBy(NamedReference[] clusteringColumns) {
        return new ClusterBy(clusteringColumns);
    }

    public static final class SetProperty
    implements TableChange {
        private final String property;
        private final String value;

        private SetProperty(String property, String value) {
            this.property = property;
            this.value = value;
        }

        public String property() {
            return this.property;
        }

        public String value() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SetProperty that = (SetProperty)o;
            return this.property.equals(that.property) && this.value.equals(that.value);
        }

        public int hashCode() {
            return Objects.hash(this.property, this.value);
        }
    }

    public static final class RemoveProperty
    implements TableChange {
        private final String property;

        private RemoveProperty(String property) {
            this.property = property;
        }

        public String property() {
            return this.property;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoveProperty that = (RemoveProperty)o;
            return this.property.equals(that.property);
        }

        public int hashCode() {
            return Objects.hash(this.property);
        }
    }

    public static final class AddColumn
    implements ColumnChange {
        private final String[] fieldNames;
        private final DataType dataType;
        private final boolean isNullable;
        private final String comment;
        private final ColumnPosition position;
        private final ColumnDefaultValue defaultValue;

        private AddColumn(String[] fieldNames, DataType dataType, boolean isNullable, String comment, ColumnPosition position, ColumnDefaultValue defaultValue) {
            this.fieldNames = fieldNames;
            this.dataType = dataType;
            this.isNullable = isNullable;
            this.comment = comment;
            this.position = position;
            this.defaultValue = defaultValue;
        }

        @Override
        public String[] fieldNames() {
            return this.fieldNames;
        }

        public DataType dataType() {
            return this.dataType;
        }

        public boolean isNullable() {
            return this.isNullable;
        }

        @Nullable
        public String comment() {
            return this.comment;
        }

        @Nullable
        public ColumnPosition position() {
            return this.position;
        }

        @Nullable
        public ColumnDefaultValue defaultValue() {
            return this.defaultValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AddColumn addColumn = (AddColumn)o;
            return this.isNullable == addColumn.isNullable && Arrays.equals(this.fieldNames, addColumn.fieldNames) && this.dataType.equals(addColumn.dataType) && Objects.equals(this.comment, addColumn.comment) && Objects.equals(this.position, addColumn.position) && Objects.equals(this.defaultValue, addColumn.defaultValue);
        }

        public int hashCode() {
            int result = Objects.hash(this.dataType, this.isNullable, this.comment, this.position);
            result = 31 * result + Arrays.hashCode(this.fieldNames);
            return result;
        }
    }

    public static interface ColumnPosition {
        public static ColumnPosition first() {
            return First.INSTANCE;
        }

        public static ColumnPosition after(String column) {
            return new After(column);
        }
    }

    public static final class RenameColumn
    implements ColumnChange {
        private final String[] fieldNames;
        private final String newName;

        private RenameColumn(String[] fieldNames, String newName) {
            this.fieldNames = fieldNames;
            this.newName = newName;
        }

        @Override
        public String[] fieldNames() {
            return this.fieldNames;
        }

        public String newName() {
            return this.newName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RenameColumn that = (RenameColumn)o;
            return Arrays.equals(this.fieldNames, that.fieldNames) && this.newName.equals(that.newName);
        }

        public int hashCode() {
            int result = Objects.hash(this.newName);
            result = 31 * result + Arrays.hashCode(this.fieldNames);
            return result;
        }
    }

    public static final class UpdateColumnType
    implements ColumnChange {
        private final String[] fieldNames;
        private final DataType newDataType;

        private UpdateColumnType(String[] fieldNames, DataType newDataType) {
            this.fieldNames = fieldNames;
            this.newDataType = newDataType;
        }

        @Override
        public String[] fieldNames() {
            return this.fieldNames;
        }

        public DataType newDataType() {
            return this.newDataType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateColumnType that = (UpdateColumnType)o;
            return Arrays.equals(this.fieldNames, that.fieldNames) && this.newDataType.equals(that.newDataType);
        }

        public int hashCode() {
            int result = Objects.hash(this.newDataType);
            result = 31 * result + Arrays.hashCode(this.fieldNames);
            return result;
        }
    }

    public static final class UpdateColumnNullability
    implements ColumnChange {
        private final String[] fieldNames;
        private final boolean nullable;

        private UpdateColumnNullability(String[] fieldNames, boolean nullable) {
            this.fieldNames = fieldNames;
            this.nullable = nullable;
        }

        @Override
        public String[] fieldNames() {
            return this.fieldNames;
        }

        public boolean nullable() {
            return this.nullable;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateColumnNullability that = (UpdateColumnNullability)o;
            return this.nullable == that.nullable && Arrays.equals(this.fieldNames, that.fieldNames);
        }

        public int hashCode() {
            int result = Objects.hash(this.nullable);
            result = 31 * result + Arrays.hashCode(this.fieldNames);
            return result;
        }
    }

    public static final class UpdateColumnComment
    implements ColumnChange {
        private final String[] fieldNames;
        private final String newComment;

        private UpdateColumnComment(String[] fieldNames, String newComment) {
            this.fieldNames = fieldNames;
            this.newComment = newComment;
        }

        @Override
        public String[] fieldNames() {
            return this.fieldNames;
        }

        public String newComment() {
            return this.newComment;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateColumnComment that = (UpdateColumnComment)o;
            return Arrays.equals(this.fieldNames, that.fieldNames) && this.newComment.equals(that.newComment);
        }

        public int hashCode() {
            int result = Objects.hash(this.newComment);
            result = 31 * result + Arrays.hashCode(this.fieldNames);
            return result;
        }
    }

    public static final class UpdateColumnPosition
    implements ColumnChange {
        private final String[] fieldNames;
        private final ColumnPosition position;

        private UpdateColumnPosition(String[] fieldNames, ColumnPosition position) {
            this.fieldNames = fieldNames;
            this.position = position;
        }

        @Override
        public String[] fieldNames() {
            return this.fieldNames;
        }

        public ColumnPosition position() {
            return this.position;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateColumnPosition that = (UpdateColumnPosition)o;
            return Arrays.equals(this.fieldNames, that.fieldNames) && this.position.equals(that.position);
        }

        public int hashCode() {
            int result = Objects.hash(this.position);
            result = 31 * result + Arrays.hashCode(this.fieldNames);
            return result;
        }
    }

    public static final class UpdateColumnDefaultValue
    implements ColumnChange {
        private final String[] fieldNames;
        private final String newDefaultValue;

        private UpdateColumnDefaultValue(String[] fieldNames, String newDefaultValue) {
            this.fieldNames = fieldNames;
            this.newDefaultValue = newDefaultValue;
        }

        @Override
        public String[] fieldNames() {
            return this.fieldNames;
        }

        public String newDefaultValue() {
            return this.newDefaultValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateColumnDefaultValue that = (UpdateColumnDefaultValue)o;
            return Arrays.equals(this.fieldNames, that.fieldNames) && this.newDefaultValue.equals(that.newDefaultValue());
        }

        public int hashCode() {
            int result = Objects.hash(this.newDefaultValue);
            result = 31 * result + Arrays.hashCode(this.fieldNames);
            return result;
        }
    }

    public static final class DeleteColumn
    implements ColumnChange {
        private final String[] fieldNames;
        private final Boolean ifExists;

        private DeleteColumn(String[] fieldNames, Boolean ifExists) {
            this.fieldNames = fieldNames;
            this.ifExists = ifExists;
        }

        @Override
        public String[] fieldNames() {
            return this.fieldNames;
        }

        public Boolean ifExists() {
            return this.ifExists;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeleteColumn that = (DeleteColumn)o;
            return Arrays.equals(this.fieldNames, that.fieldNames) && that.ifExists() == this.ifExists();
        }

        public int hashCode() {
            return Arrays.hashCode(this.fieldNames);
        }
    }

    public static final class ClusterBy
    implements TableChange {
        private final NamedReference[] clusteringColumns;

        private ClusterBy(NamedReference[] clusteringColumns) {
            this.clusteringColumns = clusteringColumns;
        }

        public NamedReference[] clusteringColumns() {
            return this.clusteringColumns;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClusterBy that = (ClusterBy)o;
            return Arrays.equals(this.clusteringColumns, that.clusteringColumns());
        }

        public int hashCode() {
            return Arrays.hashCode(this.clusteringColumns);
        }
    }

    public static interface ColumnChange
    extends TableChange {
        public String[] fieldNames();
    }

    public static final class After
    implements ColumnPosition {
        private final String column;

        private After(String column) {
            assert (column != null);
            this.column = column;
        }

        public String column() {
            return this.column;
        }

        public String toString() {
            return "AFTER " + this.column;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            After after = (After)o;
            return this.column.equals(after.column);
        }

        public int hashCode() {
            return Objects.hash(this.column);
        }
    }

    public static final class First
    implements ColumnPosition {
        private static final First INSTANCE = new First();

        private First() {
        }

        public String toString() {
            return "FIRST";
        }
    }
}

